import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isSubItem", "title", "titleElement", "icon", "iconProps", "href", "linkProps", "items", "isCollapsible", "accordionProps", "children"],
  _excluded2 = ["renderItem", "className"],
  _excluded3 = ["items", "isSubItem", "className"],
  _excluded4 = ["className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { EuiCollapsibleNavContext } from '../context';
import { EuiCollapsedNavItem } from './collapsed';
import { EuiCollapsibleNavAccordion } from './collapsible_nav_accordion';
import { EuiCollapsibleNavGroup } from './collapsible_nav_group';
import { EuiCollapsibleNavLink } from './collapsible_nav_link';
import { euiCollapsibleNavTopItemStyles, euiCollapsibleNavItemTitleStyles, euiCollapsibleNavSubItemsStyles } from './collapsible_nav_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal DRY subcomponent shared between top level items and sub items
 * that handles title display/rendering, and can be used to recursively
 * determine whether to render an accordion or a link
 */
var EuiCollapsibleNavItemDisplay = function EuiCollapsibleNavItemDisplay(_ref) {
  var isSubItem = _ref.isSubItem,
    title = _ref.title,
    titleElement = _ref.titleElement,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    href = _ref.href,
    linkProps = _ref.linkProps,
    items = _ref.items,
    _ref$isCollapsible = _ref.isCollapsible,
    isCollapsible = _ref$isCollapsible === void 0 ? true : _ref$isCollapsible,
    accordionProps = _ref.accordionProps,
    children = _ref.children,
    props = _objectWithoutProperties(_ref, _excluded);
  var headerContent = ___EmotionJSX(EuiCollapsibleNavItemTitle, {
    title: title,
    titleElement: titleElement,
    icon: icon,
    iconProps: iconProps
  });
  if (items) {
    if (isCollapsible) {
      return ___EmotionJSX(EuiCollapsibleNavAccordion, _extends({
        buttonContent: headerContent,
        items: items,
        accordionProps: accordionProps
      }, props, {
        isSubItem: isSubItem
      }));
    } else {
      return ___EmotionJSX(EuiCollapsibleNavGroup, _extends({
        header: headerContent,
        items: items
      }, props, {
        isSubItem: isSubItem
      }));
    }
  }
  return ___EmotionJSX(EuiCollapsibleNavLink, _extends({
    href: href,
    linkProps: linkProps
  }, props, {
    // EuiLink ExclusiveUnion type shenanigans
    isSubItem: isSubItem,
    isNotAccordion: true,
    isInteractive: !!(href || props.onClick || linkProps !== null && linkProps !== void 0 && linkProps.onClick)
  }), headerContent);
};

/**
 * Internal subcomponent for title display
 */
export var EuiCollapsibleNavItemTitle = function EuiCollapsibleNavItemTitle(_ref2) {
  var title = _ref2.title,
    _ref2$titleElement = _ref2.titleElement,
    titleElement = _ref2$titleElement === void 0 ? 'span' : _ref2$titleElement,
    icon = _ref2.icon,
    iconProps = _ref2.iconProps;
  var styles = euiCollapsibleNavItemTitleStyles;
  var TitleElement = titleElement;
  return ___EmotionJSX(React.Fragment, null, icon && ___EmotionJSX(EuiIcon, _extends({
    type: icon
  }, iconProps, {
    className: classNames('euiCollapsibleNavItem__icon', iconProps === null || iconProps === void 0 ? void 0 : iconProps.className)
  })), ___EmotionJSX(TitleElement, {
    className: "euiCollapsibleNavItem__title eui-textTruncate",
    css: styles.euiCollapsibleNavItem__title
  }, title));
};

/**
 * Sub-items can either be a totally custom rendered item,
 * or they can simply be more links or accordions
 */
export var EuiCollapsibleNavSubItem = function EuiCollapsibleNavSubItem(_ref3) {
  var renderItem = _ref3.renderItem,
    className = _ref3.className,
    props = _objectWithoutProperties(_ref3, _excluded2);
  var classes = classNames('euiCollapsibleNavSubItem', className);
  var _useContext = useContext(EuiCollapsibleNavContext),
    closePortals = _useContext.closePortals;
  if (renderItem) {
    return ___EmotionJSX(React.Fragment, null, renderItem({
      closePortals: closePortals
    }));
  }
  return ___EmotionJSX(EuiCollapsibleNavItemDisplay, _extends({
    className: classes
  }, props, {
    isSubItem: true
  }));
};

/**
 * Reuseable component for rendering a group of sub items
 * Used by both `EuiCollapsibleNavGroup` and `EuiCollapsibleNavAccordion`
 */

export var EuiCollapsibleNavSubItems = function EuiCollapsibleNavSubItems(_ref4) {
  var items = _ref4.items,
    isSubItem = _ref4.isSubItem,
    className = _ref4.className,
    rest = _objectWithoutProperties(_ref4, _excluded3);
  var classes = classNames('euiCollapsibleNavItem__items', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavSubItemsStyles);
  var cssStyles = [styles.euiCollapsibleNavItem__items, isSubItem ? styles.isSubItem : styles.isTopItem];
  var itemsHaveIcons = useMemo(function () {
    return items.some(function (item) {
      return !!item.icon;
    });
  }, [items]);
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), items.map(function (item, index) {
    // If any of the sub items have an icon, default to an
    // icon of `empty` so that all text lines up vertically
    if (!item.renderItem && itemsHaveIcons && !item.icon) {
      item.icon = 'empty';
    }
    return (
      // This is an intentional circular dependency between the accordion & parent item display.
      // EuiSideNavItem is purposely recursive to support any amount of nested sub items,
      // and split up into separate files/components for better dev readability
      ___EmotionJSX(EuiCollapsibleNavSubItem, _extends({
        key: index
      }, item))
    );
  }));
};

/**
 * The actual exported component
 */

export var EuiCollapsibleNavItem = function EuiCollapsibleNavItem(_ref5) {
  var className = _ref5.className,
    props = _objectWithoutProperties(_ref5, _excluded4);
  var classes = classNames('euiCollapsibleNavItem', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavTopItemStyles);
  var _useContext2 = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext2.isCollapsed,
    isPush = _useContext2.isPush;
  return isCollapsed && isPush ? ___EmotionJSX(EuiCollapsedNavItem, _extends({
    className: classes
  }, props)) : ___EmotionJSX(EuiCollapsibleNavItemDisplay, _extends({
    className: classes
  }, props, {
    css: styles.euiCollapsibleNavTopItem,
    isSubItem: false
  }));
};