import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["href", "rel", "children", "className", "isSelected", "isInteractive", "isNotAccordion", "isSubItem", "linkProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiLink } from '../../link';
import { EuiCollapsibleNavContext } from '../context';
import { euiCollapsibleNavLinkStyles } from './collapsible_nav_link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal nav link component.
 *
 * Can be rendered as a standalone nav item, or as part of an accordion header.
 * Can also be rendered as top-level item (has a background hover) or as a
 * sub-item (renders closer to plain text).
 *
 * In terms of DOM output, follows the same logic as EuiLink (renders either
 * an `a` tag or a `button` if no valid link exists), and can also additionally
 * rendered a plain `span` if the item is not interactive.
 */
export var EuiCollapsibleNavLink = function EuiCollapsibleNavLink(_ref) {
  var href = _ref.href,
    rel = _ref.rel,
    children = _ref.children,
    className = _ref.className,
    isSelected = _ref.isSelected,
    _ref$isInteractive = _ref.isInteractive,
    isInteractive = _ref$isInteractive === void 0 ? true : _ref$isInteractive,
    isNotAccordion = _ref.isNotAccordion,
    isSubItem = _ref.isSubItem,
    linkProps = _ref.linkProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNavLink', className, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.className));
  var styles = useEuiMemoizedStyles(euiCollapsibleNavLinkStyles);
  var cssStyles = [styles.euiCollapsibleNavLink, isSelected && styles.isSelected, isSubItem ? styles.isSubItem : styles.isTopItem.isTopItem, isNotAccordion && !isSubItem && styles.isTopItem.isNotAccordion, isInteractive && !isSelected && !isSubItem && styles.isTopItem.isInteractive, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.css)];
  var _useContext = useContext(EuiCollapsibleNavContext),
    closePortals = _useContext.closePortals;
  var onClick = useCallback(function (event) {
    var _rest$onClick, _linkProps$onClick;
    (_rest$onClick = rest.onClick) === null || _rest$onClick === void 0 || _rest$onClick.call(rest, event);
    linkProps === null || linkProps === void 0 || (_linkProps$onClick = linkProps.onClick) === null || _linkProps$onClick === void 0 || _linkProps$onClick.call(linkProps, event);
    if (!event.defaultPrevented) {
      closePortals === null || closePortals === void 0 || closePortals(event);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [rest.onClick, linkProps === null || linkProps === void 0 ? void 0 : linkProps.onClick, closePortals]);
  return isInteractive ? ___EmotionJSX(EuiLink, _extends({
    href: href,
    rel: rel
  }, _objectSpread(_objectSpread({}, rest), linkProps), {
    // EuiLink ExclusiveUnion shenanigans
    onClick: onClick,
    className: classes,
    css: cssStyles
  }), children) : ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};