import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["type", "palette", "className", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classnames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiColorPaletteDisplayFixed } from './color_palette_display_fixed';
import { EuiColorPaletteDisplayGradient } from './color_palette_display_gradient';
import { euiColorPaletteDisplayStyles } from './color_palette_display.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var EuiColorPaletteDisplay = function EuiColorPaletteDisplay(_ref) {
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'fixed' : _ref$type,
    palette = _ref.palette,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiColorPaletteDisplay', className);
  var styles = useEuiMemoizedStyles(euiColorPaletteDisplayStyles);
  var cssStyles = [styles.euiColorPaletteDisplay, styles[size]];
  return ___EmotionJSX(React.Fragment, null, type === 'fixed' ? ___EmotionJSX(EuiColorPaletteDisplayFixed, _extends({
    css: cssStyles,
    className: classes,
    palette: palette
  }, rest)) : ___EmotionJSX(EuiColorPaletteDisplayGradient, _extends({
    css: cssStyles,
    className: classes,
    palette: palette
  }, rest)));
};