import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isInvalid", "onChange", "readOnly", "valueOfSelected", "palettes", "append", "prepend", "selectionDisplay"],
  _excluded2 = ["type", "value", "title", "palette"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo } from 'react';
import { EuiSpacer } from '../../spacer';
import { EuiText } from '../../text';
import { EuiSuperSelect } from '../../form/super_select'; // Note: needs to be pointed at this specific subdir for Storybook to inherit types correctly??

import { EuiColorPaletteDisplay } from '../color_palette_display';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiColorPalettePicker = function EuiColorPalettePicker(_ref) {
  var className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    disabled = _ref.disabled,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    onChange = _ref.onChange,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    valueOfSelected = _ref.valueOfSelected,
    palettes = _ref.palettes,
    append = _ref.append,
    prepend = _ref.prepend,
    _ref$selectionDisplay = _ref.selectionDisplay,
    selectionDisplay = _ref$selectionDisplay === void 0 ? 'palette' : _ref$selectionDisplay,
    rest = _objectWithoutProperties(_ref, _excluded);
  var getPalette = useCallback(function (_ref2) {
    var type = _ref2.type,
      palette = _ref2.palette,
      title = _ref2.title;
    return ___EmotionJSX(EuiColorPaletteDisplay, {
      type: type,
      palette: palette,
      title: title
    });
  }, []);
  var paletteOptions = useMemo(function () {
    return palettes.map(function (item) {
      var type = item.type,
        value = item.value,
        title = item.title,
        palette = item.palette,
        rest = _objectWithoutProperties(item, _excluded2);
      var paletteForDisplay = item.type !== 'text' ? getPalette(item) : null;
      return _objectSpread({
        value: String(value),
        inputDisplay: selectionDisplay === 'title' || type === 'text' ? title : paletteForDisplay,
        dropdownDisplay: ___EmotionJSX("div", {
          className: "euiColorPalettePicker__item"
        }, title && type !== 'text' &&
        // Accessible labels are managed by color_palette_display_fixed and
        // color_palette_display_gradient. Adding the aria-hidden attribute
        // here to ensure screen readers don't speak the listbox options twice.
        ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiText, {
          "aria-hidden": "true",
          className: "euiColorPalettePicker__itemTitle",
          size: "xs"
        }, title), ___EmotionJSX(EuiSpacer, {
          size: "xs"
        })), type === 'text' ? title : paletteForDisplay)
      }, rest);
    });
  }, [getPalette, palettes, selectionDisplay]);
  return ___EmotionJSX(EuiSuperSelect, _extends({
    className: className,
    options: paletteOptions,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    hasDividers: true,
    isInvalid: isInvalid,
    compressed: compressed,
    disabled: disabled,
    readOnly: readOnly,
    fullWidth: fullWidth,
    append: append,
    prepend: prepend
  }, rest));
};