import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiColorPicker } from './color_picker';
import { EuiFormRow } from '../form';
import { useColorPickerState } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var ColorPicker = function ColorPicker() {
  var _useColorPickerState = useColorPickerState('#D36086'),
    _useColorPickerState2 = _slicedToArray(_useColorPickerState, 3),
    color = _useColorPickerState2[0],
    setColor = _useColorPickerState2[1],
    errors = _useColorPickerState2[2];
  return ___EmotionJSX(EuiFormRow, {
    label: "Pick a color",
    isInvalid: !!errors,
    error: errors
  }, ___EmotionJSX(EuiColorPicker, {
    onChange: setColor,
    color: color,
    isInvalid: !!errors
  }));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(ColorPicker, null));
});
describe('EuiColorPicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the picker is opened', function () {
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').realClick();
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('exist');
      cy.checkAxe();
      cy.realPress('Escape');
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.realPress('Tab');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.realPress('Enter');
      cy.repeatRealPress('ArrowDown', 5);
      cy.repeatRealPress('ArrowRight', 3);
      cy.realPress('Escape');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.attr', 'value', '#C9557B');
      cy.checkAxe();
    });
  });
});