import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "color", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiI18n } from '../i18n';
import { getChromaColor } from './utils';
import { euiColorPickerSwatchStyles } from './color_picker_swatch.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiColorPickerSwatch = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var className = _ref.className,
    color = _ref.color,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiColorPickerSwatch', className);
  var styles = useEuiMemoizedStyles(euiColorPickerSwatchStyles);
  var chromaColor = useMemo(function () {
    return getChromaColor(color, true);
  }, [color]);
  var background = useMemo(function () {
    return chromaColor ? chromaColor.css() : 'transparent';
  }, [chromaColor]);
  var ariaLabel = useEuiI18n('euiColorPickerSwatch.ariaLabel', 'Select {color} as the color', {
    color: color
  });
  return ___EmotionJSX("button", _extends({
    type: "button",
    css: styles.euiColorPickerSwatch,
    className: classes,
    "aria-label": ariaLabel,
    ref: ref,
    style: _objectSpread({
      background: background
    }, style)
  }, rest));
});
EuiColorPickerSwatch.displayName = 'EuiColorPickerSwatch';