/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalCSS, mathWithUnits } from '../../global_styling';
import { euiRangeThumbPerBrowser, euiRangeThumbStyle, euiRangeThumbFocusBoxShadow } from '../form/range/range.styles';
export var euiHueStyles = function euiHueStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var height = euiTheme.size.m;
  var thumbSize = euiTheme.size.l;
  var thumbBorder = mathWithUnits(euiTheme.border.width.thick, function (x) {
    return x * 1.5;
  });
  var thumbBoxShadow = "\n    0 2px 2px -1px ".concat(transparentize(euiTheme.colors.shadow, 0.2), ",\n    0 1px 5px -2px ").concat(transparentize(euiTheme.colors.shadow, 0.2));
  return {
    // This wraps the range and sets a rainbow gradient,
    // which allows the range thumb to be larger than the visible track
    euiHue: /*#__PURE__*/css(logicalCSS('height', height), " border-radius:", height, ";background:linear-gradient(\n        to right,\n        #ff3232 0%,\n        #fff130 20%,\n        #45ff30 35%,\n        #28fff0 52%,\n        #282cff 71%,\n        #ff28fb 88%,\n        #ff0094 100%\n      );;label:euiHue;"),
    euiHue__range: /*#__PURE__*/css(logicalCSS('height', thumbSize), logicalCSS('width', "calc(100% + 2px)"), logicalCSS('margin-horizontal', '-1px'), " ", logicalCSS('margin-top', mathWithUnits(height, function (x) {
      return x / -2;
    })), "appearance:none;background:transparent;&::-webkit-slider-thumb{-webkit-appearance:none;}", euiRangeThumbPerBrowser([euiRangeThumbStyle(euiThemeContext), 'background-color: inherit', "border-width: ".concat(thumbBorder), 'border-radius: 100%', "box-shadow: ".concat(thumbBoxShadow)].join(';\n')), "&:focus{outline:none;}&:focus-visible{", euiRangeThumbPerBrowser(euiRangeThumbFocusBoxShadow(euiThemeContext)), ";};label:euiHue__range;")
  };
};