import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "color", "data-test-subj", "hex", "id", "onChange", "onKeyDown"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useEffect, useRef, useState, useCallback } from 'react';
import classNames from 'classnames';
import { keys, useMouseMove, useEuiMemoizedStyles, useGeneratedHtmlId } from '../../services';
import { isNil } from '../../services/predicate';
import { logicalStyles } from '../../global_styling';
import { useEuiI18n } from '../i18n';
import { getEventPosition } from './utils';
import { euiSaturationStyles } from './saturation.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var colorDefaultValue = [1, 0, 0];
export var EuiSaturation = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? colorDefaultValue : _ref$color,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'euiSaturation' : _ref$dataTestSubj,
    hex = _ref.hex,
    _id = _ref.id,
    onChange = _ref.onChange,
    onKeyDown = _ref.onKeyDown,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSaturation', className);
  var styles = useEuiMemoizedStyles(euiSaturationStyles);
  var id = useGeneratedHtmlId({
    conditionalId: _id
  });
  var instructionsId = "".concat(id, "-instructions");
  var indicatorId = "".concat(id, "-saturationIndicator");
  var _useEuiI18n = useEuiI18n(['euiSaturation.ariaLabel', 'euiSaturation.screenReaderInstructions'], ['HSV color mode saturation and value 2-axis slider', "Arrow keys to navigate the square color gradient. Coordinates will be used to calculate HSV color mode 'saturation' and 'value' numbers, in the range of 0 to 1. Left and right to change the saturation. Up and down change the value."]),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    roleDescString = _useEuiI18n2[0],
    instructionsString = _useEuiI18n2[1];
  var _useState = useState({
      left: 0,
      top: 0
    }),
    _useState2 = _slicedToArray(_useState, 2),
    indicator = _useState2[0],
    setIndicator = _useState2[1];
  var _useState3 = useState([]),
    _useState4 = _slicedToArray(_useState3, 2),
    lastColor = _useState4[0],
    setLastColor = _useState4[1];
  var boxRef = useRef(null);
  useEffect(function () {
    // Mimics `componentDidMount` and `componentDidUpdate`
    var _color = _slicedToArray(color, 3),
      s = _color[1],
      v = _color[2];
    if (!isNil(boxRef.current) && lastColor.join() !== color.join()) {
      var _boxRef$current$getBo = boxRef.current.getBoundingClientRect(),
        height = _boxRef$current$getBo.height,
        width = _boxRef$current$getBo.width;
      setIndicator({
        left: s * width,
        top: (1 - v) * height
      });
    }
  }, [color, lastColor]);
  var calculateColor = useCallback(function (_ref2) {
    var top = _ref2.top,
      height = _ref2.height,
      left = _ref2.left,
      width = _ref2.width;
    var _color2 = _slicedToArray(color, 1),
      h = _color2[0];
    var s = left / width;
    var v = 1 - top / height;
    return [h, s, v];
  }, [color]);
  var handleUpdate = useCallback(function (box) {
    var left = box.left,
      top = box.top;
    setIndicator({
      left: left,
      top: top
    });
    var newColor = calculateColor(box);
    setLastColor(newColor);
    onChange(newColor);
  }, [calculateColor, onChange]);
  var handleChange = useCallback(function (location) {
    if (isNil(boxRef === null || boxRef === void 0 ? void 0 : boxRef.current)) return;
    var box = getEventPosition(location, boxRef.current);
    handleUpdate(box);
  }, [handleUpdate]);
  var _useMouseMove = useMouseMove(handleChange, boxRef.current),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var handleKeyDown = useCallback(function (event) {
    onKeyDown === null || onKeyDown === void 0 || onKeyDown(event);
    if (isNil(boxRef === null || boxRef === void 0 ? void 0 : boxRef.current)) return;
    var _boxRef$current$getBo2 = boxRef.current.getBoundingClientRect(),
      height = _boxRef$current$getBo2.height,
      width = _boxRef$current$getBo2.width;
    var left = indicator.left,
      top = indicator.top;
    var heightScale = height / 100;
    var widthScale = width / 100;
    var newLeft = left;
    var newTop = top;
    switch (event.key) {
      case keys.ARROW_DOWN:
        event.preventDefault();
        newTop = top < height ? top + heightScale : height;
        break;
      case keys.ARROW_LEFT:
        event.preventDefault();
        newLeft = left > 0 ? left - widthScale : 0;
        break;
      case keys.ARROW_UP:
        event.preventDefault();
        newTop = top > 0 ? top - heightScale : 0;
        break;
      case keys.ARROW_RIGHT:
        event.preventDefault();
        newLeft = left < width ? left + widthScale : width;
        break;
      default:
        return;
    }
    var newPosition = {
      left: newLeft,
      top: newTop
    };
    setIndicator(newPosition);
    var newColor = calculateColor(_objectSpread({
      width: width,
      height: height
    }, newPosition));
    onChange(newColor);
  }, [calculateColor, indicator, onChange, onKeyDown]);
  return ___EmotionJSX("div", _extends({
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction,
    onKeyDown: handleKeyDown,
    ref: ref,
    css: styles.euiSaturation,
    className: classes,
    "data-test-subj": dataTestSubj,
    style: {
      background: "hsl(".concat(color[0], ", 100%, 50%)")
    },
    tabIndex: -1
  }, rest), ___EmotionJSX("div", {
    css: styles.euiSaturation__lightness,
    className: "euiSaturation__lightness",
    ref: boxRef
  }, ___EmotionJSX("div", {
    css: styles.euiSaturation__saturation,
    className: "euiSaturation__saturation"
  })), ___EmotionJSX("button", {
    id: indicatorId,
    css: styles.euiSaturation__indicator,
    className: "euiSaturation__indicator",
    style: logicalStyles(indicator),
    "aria-roledescription": roleDescString,
    "aria-label": hex,
    "aria-describedby": instructionsId
  }), ___EmotionJSX("span", {
    hidden: true,
    "aria-live": "assertive"
  }, hex), ___EmotionJSX("span", {
    hidden: true,
    id: instructionsId
  }, instructionsString));
});
EuiSaturation.displayName = 'EuiSaturation';