function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
import { euiFormControlStyles, euiFormControlDefaultShadow, euiFormControlText } from '../../form/form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "kedu1h-plainText",
  styles: "align-items:center;cursor:text;label:plainText;"
} : {
  name: "kedu1h-plainText",
  styles: "align-items:center;cursor:text;label:plainText;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "dkzr1g-multiSelect",
  styles: "flex-wrap:wrap;label:multiSelect;"
} : {
  name: "dkzr1g-multiSelect",
  styles: "flex-wrap:wrap;label:multiSelect;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiComboBoxInputStyles = function euiComboBoxInputStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = euiFormControlStyles(euiThemeContext);
  return {
    // Wrapper which visually mimics a form control
    euiComboBoxInputWrapper: /*#__PURE__*/css(euiFormControlDefaultShadow(euiThemeContext), " display:flex;;label:euiComboBoxInputWrapper;"),
    multiSelect: _ref2,
    uncompressed: "\n      ".concat(formStyles.uncompressed, "\n      ").concat(logicalCSS('height', 'auto'), "\n      ").concat(logicalCSS('padding-vertical', euiTheme.size.s), "\n      ").concat(logicalCSS('padding-left', euiTheme.size.s), "\n      column-gap: ").concat(euiTheme.size.s, ";\n      row-gap: ").concat(euiTheme.size.xs, ";\n    "),
    compressed: /*#__PURE__*/css(formStyles.compressed, " ", logicalCSS('height', 'auto'), " ", logicalCSS('padding-vertical', euiTheme.size.xs), " ", logicalCSS('padding-left', euiTheme.size.xs), " column-gap:", euiTheme.size.xs, ";row-gap:", euiTheme.size.xxs, ";;label:compressed;"),
    plainText: {
      plainText: _ref,
      compressed: "\n        ".concat(logicalCSS('padding-left', euiTheme.size.s), "\n      "),
      uncompressed: "\n        ".concat(logicalCSS('padding-left', euiTheme.size.m), "\n      ")
    },
    invalid: /*#__PURE__*/css(formStyles.invalid, ";label:invalid;"),
    disabled: /*#__PURE__*/css(formStyles.disabled, ";label:disabled;"),
    open: /*#__PURE__*/css(formStyles.focus, ";label:open;"),
    inGroup: /*#__PURE__*/css(formStyles.inGroup, ";label:inGroup;"),
    // Actual input element, which has variable width depending on its value
    euiComboBoxInput: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.l), " ", logicalCSS('min-width', '2px'), " ", logicalCSS('max-width', '100%'), euiFormControlText(euiThemeContext), " background:transparent;&:disabled{color:", euiTheme.colors.disabledText, ";}appearance:none!important;border:none!important;box-shadow:none!important;outline:none!important;;label:euiComboBoxInput;"),
    // EuiFormControlLayout overrides
    formLayout: {
      euiComboBox__formControlLayout: /*#__PURE__*/css(";label:euiComboBox__formControlLayout;"),
      // Allow the form control to expand to any height to accommodate multiple rows of pills
      multiSelect: /*#__PURE__*/css(logicalCSS('height', 'auto'), ";;label:multiSelect;")
    }
  };
};