import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "color", "onClick", "onClickAriaLabel", "onClose", "option"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiBadge } from '../../badge';
import { EuiI18n } from '../../i18n';
import { EuiComboBoxOptionAppendPrepend } from '../utils';
import { euiComboBoxPillStyles } from './combo_box_pill.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiComboBoxPill = function EuiComboBoxPill(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'hollow' : _ref$color,
    onClick = _ref.onClick,
    onClickAriaLabel = _ref.onClickAriaLabel,
    onClose = _ref.onClose,
    option = _ref.option,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiComboBoxPill', className);
  var styles = useEuiMemoizedStyles(euiComboBoxPillStyles);
  var cssStyles = styles.euiComboBoxPill;
  var onClickProps = onClick && onClickAriaLabel ? {
    onClick: onClick,
    onClickAriaLabel: onClickAriaLabel
  } : {};
  var content = ___EmotionJSX(EuiComboBoxOptionAppendPrepend, {
    option: option,
    classNamePrefix: "euiComboBoxPill"
  }, ___EmotionJSX("span", {
    className: "eui-textTruncate"
  }, children));
  if (onClose) {
    return ___EmotionJSX(EuiI18n, {
      token: "euiComboBoxPill.removeSelection",
      default: "Remove {children} from selection in this group",
      values: {
        children: children
      }
    }, function (removeSelection) {
      return ___EmotionJSX(EuiBadge, _extends({
        css: cssStyles,
        className: classes,
        color: color,
        "data-test-subj": "euiComboBoxPill",
        iconOnClick: function iconOnClick() {
          return onClose(option);
        },
        iconOnClickAriaLabel: removeSelection,
        iconSide: "right",
        iconType: "cross",
        title: children
      }, onClickProps, rest), content);
    });
  }
  return ___EmotionJSX(EuiBadge, _extends({
    css: cssStyles,
    className: classes,
    color: color,
    "data-test-subj": "euiComboBoxPill",
    title: children
  }, rest, onClickProps), content);
};