/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../../global_styling';
export var euiComboBoxPillStyles = function euiComboBoxPillStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Ensure the input doesn't drop to the next line when the EuiBadge has a very long text
  var pillMaxWidth = "calc(100% - ".concat(euiTheme.size.xxs, " - ").concat(euiTheme.size.base, ")");
  var pillHeight = mathWithUnits(euiTheme.size.l, function (x) {
    return x - 2;
  });
  var pillLineHeight = mathWithUnits(pillHeight, function (x) {
    return x - 2;
  });
  return {
    euiComboBoxPill: /*#__PURE__*/css(logicalCSS('max-width', pillMaxWidth), " ", logicalCSS('height', pillHeight), " line-height:", pillLineHeight, ";vertical-align:baseline;", logicalCSS('margin-vertical', '1px'), "&+.euiBadge{", logicalCSS('margin-left', 0), ";}.euiBadge__text{display:flex;align-items:center;.euiIcon{display:block;}};label:euiComboBoxPill;")
  };
};