/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits, euiScrollBarStyles, euiTextBreakWord, euiTextTruncate } from '../../../global_styling';
import { euiTitle } from '../../title/title.styles';
export var LIST_MAX_HEIGHT = 200;
export var euiComboBoxOptionListStyles = function euiComboBoxOptionListStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiComboBoxOptionList: /*#__PURE__*/css(logicalCSS('max-height', "".concat(LIST_MAX_HEIGHT, "px")), " overflow:hidden;.euiTextTruncate{pointer-events:none;}.euiComboBoxOption__contentWrapper{display:flex;align-items:center;}.euiComboBoxOption__content{flex:1;text-align:start;", euiTextTruncate(), ";}.euiComboBoxOption__emptyStateText{flex:1;text-align:start;", logicalCSS('margin-bottom', 0), ";}.euiComboBoxOption__enterBadge{", logicalCSS('margin-left', euiTheme.size.xs), ";}.euiComboBoxTitle{display:flex;", logicalCSS('padding-horizontal', euiTheme.size.s), logicalCSS('padding-top', mathWithUnits(euiTheme.size.s, function (x) {
      return x + 1;
    })), " ", logicalCSS('padding-bottom', euiTheme.size.xs), " ", euiTitle(euiThemeContext, 'xxxs'), ";};label:euiComboBoxOptionList;"),
    euiComboBoxOptionList__virtualization: /*#__PURE__*/css(euiScrollBarStyles(euiThemeContext), ";;label:euiComboBoxOptionList__virtualization;"),
    euiComboBoxOptionsList__empty: /*#__PURE__*/css("padding:", euiTheme.size.s, ";text-align:center;", euiTextBreakWord(), ";;label:euiComboBoxOptionsList__empty;")
  };
};