import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

export var transformForCaseSensitivity = function transformForCaseSensitivity(string, isCaseSensitive) {
  return isCaseSensitive ? string : string.toLowerCase();
};
export var flattenOptionGroups = function flattenOptionGroups(optionsOrGroups) {
  return optionsOrGroups.reduce(function (options, optionOrGroup) {
    if (optionOrGroup.options) {
      options = options.concat(optionOrGroup.options);
    } else {
      options.push(optionOrGroup);
    }
    return options;
  }, []);
};
export var getSelectedOptionForSearchValue = function getSelectedOptionForSearchValue(_ref) {
  var isCaseSensitive = _ref.isCaseSensitive,
    searchValue = _ref.searchValue,
    selectedOptions = _ref.selectedOptions,
    optionKey = _ref.optionKey;
  var normalizedSearchValue = transformForCaseSensitivity(searchValue, isCaseSensitive);
  return selectedOptions.find(function (option) {
    var normalizedOption = transformForCaseSensitivity(option.label, isCaseSensitive);
    return normalizedOption === normalizedSearchValue && (!optionKey || option.key === optionKey);
  });
};
var collectMatchingOption = function collectMatchingOption(_ref2) {
  var accumulator = _ref2.accumulator,
    option = _ref2.option,
    selectedOptions = _ref2.selectedOptions,
    searchValue = _ref2.searchValue,
    normalizedSearchValue = _ref2.normalizedSearchValue,
    isCaseSensitive = _ref2.isCaseSensitive,
    isPreFiltered = _ref2.isPreFiltered,
    showPrevSelected = _ref2.showPrevSelected,
    optionMatcher = _ref2.optionMatcher;
  // Only show options which haven't yet been selected unless requested.
  var selectedOption = getSelectedOptionForSearchValue({
    isCaseSensitive: isCaseSensitive,
    searchValue: option.label,
    selectedOptions: selectedOptions,
    optionKey: option.key
  });
  if (selectedOption && !showPrevSelected) {
    return false;
  }

  // If the options have already been pre-filtered then we can skip filtering against the search value.
  if (isPreFiltered) {
    accumulator.push(option);
    return;
  }
  if (!normalizedSearchValue) {
    accumulator.push(option);
    return;
  }
  var isMatching = optionMatcher({
    option: option,
    searchValue: searchValue,
    normalizedSearchValue: normalizedSearchValue,
    isCaseSensitive: isCaseSensitive !== null && isCaseSensitive !== void 0 ? isCaseSensitive : true
  });
  if (isMatching) {
    accumulator.push(option);
  }
};
export var getMatchingOptions = function getMatchingOptions(_ref3) {
  var options = _ref3.options,
    selectedOptions = _ref3.selectedOptions,
    searchValue = _ref3.searchValue,
    optionMatcher = _ref3.optionMatcher,
    _ref3$isCaseSensitive = _ref3.isCaseSensitive,
    isCaseSensitive = _ref3$isCaseSensitive === void 0 ? false : _ref3$isCaseSensitive,
    _ref3$isPreFiltered = _ref3.isPreFiltered,
    isPreFiltered = _ref3$isPreFiltered === void 0 ? false : _ref3$isPreFiltered,
    _ref3$showPrevSelecte = _ref3.showPrevSelected,
    showPrevSelected = _ref3$showPrevSelecte === void 0 ? false : _ref3$showPrevSelecte,
    _ref3$sortMatchesBy = _ref3.sortMatchesBy,
    sortMatchesBy = _ref3$sortMatchesBy === void 0 ? 'none' : _ref3$sortMatchesBy;
  var normalizedSearchValue = transformForCaseSensitivity(searchValue.trim(), isCaseSensitive);
  var matchingOptions = [];
  options.forEach(function (option) {
    if (option.options) {
      var matchingOptionsForGroup = [];
      option.options.forEach(function (groupOption) {
        collectMatchingOption({
          accumulator: matchingOptionsForGroup,
          option: groupOption,
          selectedOptions: selectedOptions,
          searchValue: searchValue,
          normalizedSearchValue: normalizedSearchValue,
          isCaseSensitive: isCaseSensitive,
          isPreFiltered: isPreFiltered,
          showPrevSelected: showPrevSelected,
          optionMatcher: optionMatcher
        });
      });
      if (matchingOptionsForGroup.length > 0) {
        // Add option for group label
        matchingOptions.push({
          key: option.key,
          label: option.label,
          isGroupLabelOption: true,
          append: option.append,
          prepend: option.prepend
        });
        // Add matching options for group
        // use concat over spreading to support large arrays - https://mathiasbynens.be/demo/javascript-argument-count
        matchingOptions = matchingOptions.concat(matchingOptionsForGroup);
      }
    } else {
      collectMatchingOption({
        accumulator: matchingOptions,
        option: option,
        selectedOptions: selectedOptions,
        searchValue: searchValue,
        normalizedSearchValue: normalizedSearchValue,
        isCaseSensitive: isCaseSensitive,
        isPreFiltered: isPreFiltered,
        showPrevSelected: showPrevSelected,
        optionMatcher: optionMatcher
      });
    }
  });
  if (sortMatchesBy === 'startsWith') {
    var refObj = {
      startWith: [],
      others: []
    };
    matchingOptions.forEach(function (object) {
      var normalizedLabel = transformForCaseSensitivity(object.label, isCaseSensitive);
      if (normalizedLabel.startsWith(normalizedSearchValue)) {
        refObj.startWith.push(object);
      } else {
        refObj.others.push(object);
      }
    });
    return [].concat(_toConsumableArray(refObj.startWith), _toConsumableArray(refObj.others));
  }
  return matchingOptions;
};

/**
 * Partial string equality option matcher for EuiComboBox.
 * It matches all options with labels including the searched string.
 */
export var createPartialStringEqualityOptionMatcher = function createPartialStringEqualityOptionMatcher() {
  return function (_ref4) {
    var option = _ref4.option,
      isCaseSensitive = _ref4.isCaseSensitive,
      normalizedSearchValue = _ref4.normalizedSearchValue;
    if (!normalizedSearchValue) {
      return true;
    }
    var normalizedOption = transformForCaseSensitivity(option.label.trim(), isCaseSensitive);
    return normalizedOption.includes(normalizedSearchValue);
  };
};