import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "username", "event", "actions", "timestamp", "timelineAvatar", "timelineAvatarAriaLabel", "eventColor", "eventIcon", "eventIconAriaLabel"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiTimelineItem } from '../timeline';
import { EuiCommentEvent } from './comment_event';
import { EuiCommentTimeline } from './comment_timeline';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiComment = function EuiComment(_ref) {
  var children = _ref.children,
    className = _ref.className,
    username = _ref.username,
    event = _ref.event,
    actions = _ref.actions,
    timestamp = _ref.timestamp,
    timelineAvatar = _ref.timelineAvatar,
    timelineAvatarAriaLabel = _ref.timelineAvatarAriaLabel,
    eventColor = _ref.eventColor,
    eventIcon = _ref.eventIcon,
    eventIconAriaLabel = _ref.eventIconAriaLabel,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiComment', className);
  var isTypeUpdate = !children;
  var verticalAlign = isTypeUpdate ? 'center' : 'top';
  var mainIcon = ___EmotionJSX(EuiCommentTimeline, {
    timelineAvatar: timelineAvatar,
    timelineAvatarAriaLabel: timelineAvatarAriaLabel
  });
  return ___EmotionJSX(EuiTimelineItem, _extends({
    verticalAlign: verticalAlign,
    className: classes,
    icon: mainIcon
  }, rest), ___EmotionJSX(EuiCommentEvent, {
    username: username,
    actions: actions,
    event: event,
    timestamp: timestamp,
    eventColor: eventColor,
    eventIcon: eventIcon,
    eventIconAriaLabel: eventIconAriaLabel
  }, children));
};