/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiBorderColorCSS } from '../../global_styling';
import { EuiPanel } from '../panel';
import { EuiAvatar } from '../avatar';
import { euiCommentEventStyles, euiCommentEventHeaderStyles, euiCommentEventBodyStyles } from './comment_event.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCommentEvent = function EuiCommentEvent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    eventIcon = _ref.eventIcon,
    eventIconAriaLabel = _ref.eventIconAriaLabel,
    username = _ref.username,
    timestamp = _ref.timestamp,
    event = _ref.event,
    actions = _ref.actions,
    eventColor = _ref.eventColor;
  var classes = classNames('euiCommentEvent', className);

  /**
   * Branching logic
   */
  // the username is required so we only check if other elements are define
  var hasEventElements = eventIcon || timestamp || event || actions;
  var isTypeRegular = children && hasEventElements;
  var isTypeUpdate = !children && hasEventElements;
  var type;
  if (isTypeRegular) {
    type = 'regular';
  } else if (isTypeUpdate) {
    type = 'update';
  } else {
    type = 'custom';
  }
  if (isTypeRegular && !eventColor) {
    eventColor = 'subdued';
  }
  if (isTypeUpdate && !eventColor) {
    eventColor = 'transparent';
  }
  var showEventBorders = isTypeRegular;
  var panelProps = useMemo(function () {
    return {
      color: type === 'custom' ? 'transparent' : eventColor,
      paddingSize: type === 'custom' ? 'none' : 's',
      borderRadius: type === 'regular' ? 'none' : 'm',
      hasShadow: false // `plain` color needs this
    };
  }, [type, eventColor]);
  var isFigure = isTypeRegular;
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';

  /**
   * Styles
   */
  var borderStyles = useEuiBorderColorCSS();
  var styles = useEuiMemoizedStyles(euiCommentEventStyles);
  var cssStyles = [styles.euiCommentEvent, showEventBorders && styles.border, showEventBorders && borderStyles[eventColor]];
  var headerStyles = useEuiMemoizedStyles(euiCommentEventHeaderStyles);
  var cssHeaderStyles = [headerStyles.euiCommentEvent__header, showEventBorders && headerStyles.border, showEventBorders && borderStyles[eventColor]];
  var bodyStyles = useEuiMemoizedStyles(euiCommentEventBodyStyles);
  var cssBodyStyles = [bodyStyles.euiCommentEvent__body, bodyStyles[type]];
  return ___EmotionJSX(Element, {
    className: classes,
    css: cssStyles,
    "data-type": type
  }, hasEventElements && ___EmotionJSX(HeaderElement, {
    className: "euiCommentEvent__header",
    css: cssHeaderStyles
  }, ___EmotionJSX(EuiPanel, panelProps, ___EmotionJSX("div", {
    className: "euiCommentEvent__headerMain",
    css: headerStyles.euiCommentEvent__headerMain
  }, ___EmotionJSX("div", {
    className: "euiCommentEvent__headerData",
    css: headerStyles.euiCommentEvent__headerData
  }, eventIcon && ___EmotionJSX(EuiAvatar, {
    className: "euiCommentEvent__headerEventIcon",
    css: headerStyles.euiCommentEvent__headerEventIcon,
    size: "s",
    iconType: eventIcon,
    name: eventIconAriaLabel ? eventIconAriaLabel : '',
    color: "subdued",
    "aria-hidden": !eventIconAriaLabel
  }), username && ___EmotionJSX("div", {
    className: "euiCommentEvent__headerUsername",
    css: headerStyles.euiCommentEvent__headerUsername
  }, username), event && ___EmotionJSX("div", {
    className: "euiCommentEvent__headerEvent",
    css: headerStyles.euiCommentEvent__headerEvent
  }, event), timestamp && ___EmotionJSX("div", {
    className: "euiCommentEvent__headerTimestamp"
  }, ___EmotionJSX("time", null, timestamp))), actions && ___EmotionJSX("div", {
    className: "euiCommentEvent__headerActions",
    css: headerStyles.euiCommentEvent__headerActions
  }, actions)))), children && ___EmotionJSX("div", {
    className: "euiCommentEvent__body",
    css: cssBodyStyles
  }, children));
};