/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiAvatar } from '../avatar';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCommentTimeline = function EuiCommentTimeline(_ref) {
  var timelineAvatar = _ref.timelineAvatar,
    timelineAvatarAriaLabel = _ref.timelineAvatarAriaLabel;
  var iconRender;
  var avatarClassName = 'euiCommentAvatar';
  var iconIsString = typeof timelineAvatar === 'string';
  if (iconIsString) {
    iconRender = ___EmotionJSX(EuiAvatar, {
      className: avatarClassName,
      name: timelineAvatarAriaLabel || '',
      iconType: timelineAvatar,
      color: "subdued"
    });
  } else if (timelineAvatar) {
    iconRender = timelineAvatar;
  } else {
    iconRender = ___EmotionJSX(EuiAvatar, {
      className: avatarClassName,
      name: timelineAvatarAriaLabel || '',
      iconType: "userAvatar",
      color: "subdued"
    });
  }
  return ___EmotionJSX(React.Fragment, null, iconRender);
};