import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "hasPanel", "icon", "buttonRef", "disabled", "layoutAlign", "toolTipContent", "toolTipProps", "href", "target", "rel", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, getSecureRelForTarget, cloneElementWithCss } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { keysOf } from '../common';
import { EuiIcon } from '../icon';
import { EuiToolTip } from '../tool_tip';
import { euiContextMenuItemStyles } from './context_menu_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['s', 'm'];
var layoutAlignToClassNames = {
  center: null,
  top: 'euiContextMenu__itemLayout--top',
  bottom: 'euiContextMenu__itemLayout--bottom'
};
export var LAYOUT_ALIGN = keysOf(layoutAlignToClassNames);
export var EuiContextMenuItem = function EuiContextMenuItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    hasPanel = _ref.hasPanel,
    icon = _ref.icon,
    buttonRef = _ref.buttonRef,
    _disabled = _ref.disabled,
    _ref$layoutAlign = _ref.layoutAlign,
    layoutAlign = _ref$layoutAlign === void 0 ? 'center' : _ref$layoutAlign,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var disabled = _disabled || !isHrefValid;
  var classes = classNames('euiContextMenuItem', className);
  var styles = useEuiMemoizedStyles(euiContextMenuItemStyles);
  var cssStyles = [styles.euiContextMenuItem, styles.sizes[size], styles.layoutAlign[layoutAlign], disabled && styles.disabled];
  var iconInstance = icon && (typeof icon === 'string' ? ___EmotionJSX(EuiIcon, {
    type: icon,
    size: "m",
    className: "euiContextMenu__icon",
    css: styles.euiContextMenu__icon,
    color: "inherit" // forces the icon to inherit its parent color
  }) :
  // Assume it's already an instance of an icon.
  cloneElementWithCss(icon, {
    css: styles.euiContextMenu__icon
  }));
  var arrow = hasPanel && ___EmotionJSX(EuiIcon, {
    type: "arrowRight",
    size: "m",
    className: "euiContextMenu__arrow",
    css: styles.euiContextMenuItem__arrow
  });
  var textStyles = [styles.text.euiContextMenuItem__text, size === 's' && styles.text.s];
  var buttonContent = ___EmotionJSX(React.Fragment, null, iconInstance, ___EmotionJSX("span", {
    className: "euiContextMenuItem__text",
    css: textStyles
  }, children), arrow);
  var button;
  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !disabled) {
    var secureRel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    button = ___EmotionJSX("a", _extends({
      css: cssStyles,
      className: classes,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), buttonContent);
  } else if (href || rest.onClick || toolTipContent) {
    button = ___EmotionJSX("button", _extends({
      disabled: disabled,
      css: cssStyles,
      className: classes,
      type: "button",
      ref: buttonRef
    }, rest), buttonContent);
  } else {
    button = ___EmotionJSX("div", _extends({
      css: cssStyles,
      className: classes,
      ref: buttonRef
    }, rest), buttonContent);
  }
  if (toolTipContent) {
    var anchorClasses = classNames('eui-displayBlock', toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorClassName);
    return ___EmotionJSX(EuiToolTip, _extends({
      position: "right"
    }, toolTipProps, {
      anchorClassName: anchorClasses,
      content: toolTipContent
    }), button);
  } else {
    return button;
  }
};