import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButton } from '../button';
import { EuiCopy } from './copy';
import { EuiFormRow, EuiFieldText } from '../form';
import { EuiSpacer } from '../spacer';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Copy = function Copy() {
  var _useState = useState('I am the text that will be copied'),
    _useState2 = _slicedToArray(_useState, 2),
    copyText = _useState2[0],
    setCopyText = _useState2[1];
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiFormRow, {
    label: "Enter text that will be copied to clipboard"
  }, ___EmotionJSX(EuiFieldText, {
    value: copyText,
    onChange: function onChange(e) {
      return setCopyText(e.target.value);
    }
  })), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(EuiCopy, {
    textToCopy: copyText
  }, function (copy) {
    return ___EmotionJSX(EuiButton, {
      onClick: copy,
      "data-test-subj": "cy-copy-button"
    }, "Click to copy input text");
  }));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(Copy, null));
});
describe('EuiCopy', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the copy button is clicked', function () {
      cy.get('button[data-test-subj="cy-copy-button"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.checkAxe();
    });
  });
});