import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["renderCellValue", "cellContext", "column", "setCellContentsRef", "rowIndex", "colIndex", "rowHeightsOptions", "rowHeightUtils", "isControlColumn"],
  _excluded2 = ["width", "popoverContext", "interactiveCellId", "columnType", "className", "column", "style", "rowHeightUtils", "rowHeightsOptions", "rowManager", "pagination"],
  _excluded3 = ["isExpandable", "style", "className", "data-test-subj"],
  _excluded4 = ["columnId", "columnIndex", "rowIndex", "visibleRowIndex"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React, { Component, createRef, memo, useMemo, forwardRef } from 'react';
import { createPortal } from 'react-dom';
import { IS_JEST_ENVIRONMENT } from '../../../../utils';
import { keys, tabularCopyMarkers, useEuiMemoizedStyles } from '../../../../services';
import { EuiScreenReaderOnly } from '../../../accessibility';
import { useEuiI18n } from '../../../i18n';
import { EuiTextBlockTruncate } from '../../../text_truncate';
import { hasResizeObserver } from '../../../observer/resize_observer/resize_observer';
import { DataGridFocusContext } from '../../utils/focus';
import { EuiDataGridCellActions, EuiDataGridCellPopoverActions } from './data_grid_cell_actions';
import { DefaultCellPopover } from './data_grid_cell_popover';
import { HandleInteractiveChildren } from './focus_utils';
import { euiDataGridRowCellStyles } from './data_grid_cell.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var EuiDataGridCellContent = /*#__PURE__*/memo(function (_ref) {
  var renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    column = _ref.column,
    setCellContentsRef = _ref.setCellContentsRef,
    rowIndex = _ref.rowIndex,
    colIndex = _ref.colIndex,
    rowHeightsOptions = _ref.rowHeightsOptions,
    rowHeightUtils = _ref.rowHeightUtils,
    isControlColumn = _ref.isControlColumn,
    rest = _objectWithoutProperties(_ref, _excluded);
  // React is more permissive than the TS types indicate
  var CellElement = renderCellValue;

  // Cell height type
  var rowHeight = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions);
  var cellHeightType = useMemo(function () {
    return rowHeightUtils !== null && rowHeightUtils !== void 0 && rowHeightUtils.isAutoBelowLineCount(rowHeightsOptions, rowHeight) ? 'autoBelowLineCount' : (rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getHeightType(rowHeight)) || 'default';
  }, [rowHeightUtils, rowHeight, rowHeightsOptions]);

  // Classes and styles
  var classes = useMemo(function () {
    return classNames('euiDataGridRowCell__content', "euiDataGridRowCell__content--".concat(cellHeightType, "Height"), !isControlColumn && {
      'eui-textBreakWord': cellHeightType !== 'default',
      'eui-textTruncate': cellHeightType === 'default'
    });
  }, [cellHeightType, isControlColumn]);
  var styles = useEuiMemoizedStyles(euiDataGridRowCellStyles);
  var cssStyles = [styles.content.euiDataGridRowCell__content].concat(_toConsumableArray(isControlColumn ? [styles.content.controlColumn, styles.content.autoHeight] : [
  // Regular data cells should always inherit height from the row wrapper,
  // except for auto height
  cellHeightType === 'auto' || cellHeightType === 'autoBelowLineCount' ? styles.content.autoHeight : styles.content.defaultHeight]));
  return ___EmotionJSX(RenderTruncatedCellContent, {
    hasLineCountTruncation: (cellHeightType === 'lineCount' || cellHeightType === 'autoBelowLineCount') && !isControlColumn,
    rowHeight: rowHeight
  }, ___EmotionJSX("div", {
    ref: setCellContentsRef,
    "data-datagrid-cellcontent": true,
    className: classes,
    css: cssStyles
  }, ___EmotionJSX(CellElement, _extends({
    isDetails: false,
    "data-test-subj": "cell-content",
    rowIndex: rowIndex,
    colIndex: colIndex,
    schema: (column === null || column === void 0 ? void 0 : column.schema) || rest.columnType
  }, cellContext, rest))));
});
EuiDataGridCellContent.displayName = 'EuiDataGridCellContent';
export var EuiDataGridCell = /*#__PURE__*/function (_Component) {
  function EuiDataGridCell() {
    var _this;
    _classCallCheck(this, EuiDataGridCell);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDataGridCell, [].concat(args));
    _defineProperty(_this, "cellRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "contentObserver", void 0);
    // Cell Content ResizeObserver
    _defineProperty(_this, "popoverAnchorRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "cellContentsRef", null);
    _defineProperty(_this, "state", {
      cellProps: {},
      isFocused: false,
      isHovered: false
    });
    _defineProperty(_this, "unsubscribeCell", void 0);
    _defineProperty(_this, "style", null);
    _defineProperty(_this, "updateCellFocusContext", function () {
      _this.context.setFocusedCell([_this.props.colIndex, _this.props.visibleRowIndex]);
    });
    _defineProperty(_this, "takeFocus", function (preventScroll) {
      var cell = _this.cellRef.current;
      // Only focus the cell if not already focused on something in the cell
      if (cell && !cell.contains(document.activeElement)) {
        cell.focus({
          preventScroll: preventScroll
        });
      }
    });
    _defineProperty(_this, "recalculateAutoHeight", function () {
      var _this$props = _this.props,
        rowHeightUtils = _this$props.rowHeightUtils,
        rowHeightsOptions = _this$props.rowHeightsOptions,
        rowIndex = _this$props.rowIndex;
      if (_this.cellContentsRef && rowHeightUtils && rowHeightUtils.isAutoHeight(rowIndex, rowHeightsOptions)) {
        var _this$props2 = _this.props,
          columnId = _this$props2.columnId,
          visibleRowIndex = _this$props2.visibleRowIndex;
        var rowHeight = _this.cellContentsRef.offsetHeight;
        rowHeightUtils.setRowHeight(rowIndex, columnId, rowHeight, visibleRowIndex);
      }
    });
    _defineProperty(_this, "recalculateLineHeight", function () {
      if (!_this.props.setRowHeight) return; // setRowHeight is only passed by data_grid_body into one cell per row
      if (!_this.cellContentsRef) return;
      var _this$props3 = _this.props,
        rowHeightUtils = _this$props3.rowHeightUtils,
        rowHeightsOptions = _this$props3.rowHeightsOptions,
        rowIndex = _this$props3.rowIndex;
      var rowHeightOption = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions);
      if (rowHeightUtils !== null && rowHeightUtils !== void 0 && rowHeightUtils.isAutoBelowLineCount(rowHeightsOptions, rowHeightOption)) {
        return; // Using auto height instead
      }
      var isSingleLine = rowHeightOption == null; // Undefined rowHeightsOptions default to a single line
      var lineCount = isSingleLine ? 1 : rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getLineCount(rowHeightOption);
      if (lineCount) {
        var shouldUseHeightsCache = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.isRowHeightOverride(rowIndex, rowHeightsOptions);
        var height = rowHeightUtils.calculateHeightForLineCount(_this.cellContentsRef, lineCount);
        if (shouldUseHeightsCache) {
          var _this$props4 = _this.props,
            columnId = _this$props4.columnId,
            visibleRowIndex = _this$props4.visibleRowIndex;
          rowHeightUtils === null || rowHeightUtils === void 0 || rowHeightUtils.setRowHeight(rowIndex, columnId, height, visibleRowIndex);
        } else {
          _this.props.setRowHeight(height);
        }
      }
    });
    _defineProperty(_this, "isFocusedCell", function () {
      var _this$context$focused, _this$context$focused2;
      return ((_this$context$focused = _this.context.focusedCell) === null || _this$context$focused === void 0 ? void 0 : _this$context$focused[0]) === _this.props.colIndex && ((_this$context$focused2 = _this.context.focusedCell) === null || _this$context$focused2 === void 0 ? void 0 : _this$context$focused2[1]) === _this.props.visibleRowIndex;
    });
    _defineProperty(_this, "onFocusUpdate", function (isFocused) {
      var preventScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      _this.setState({
        isFocused: isFocused
      }, function () {
        if (isFocused) {
          _this.takeFocus(preventScroll);
        }
      });
    });
    _defineProperty(_this, "setCellProps", function (cellProps) {
      _this.setState({
        cellProps: cellProps
      });
    });
    _defineProperty(_this, "setCellContentsRef", function (ref) {
      _this.cellContentsRef = ref;
      if (ref && hasResizeObserver) {
        _this.contentObserver = new window.ResizeObserver(function () {
          _this.recalculateAutoHeight();
          _this.recalculateLineHeight();
        });
        _this.contentObserver.observe(ref);
      } else if (_this.contentObserver) {
        _this.contentObserver.disconnect();
      }
    });
    _defineProperty(_this, "isExpandable", function () {
      var _this$props$column, _this$state$cellProps;
      // A cell must always show an expansion popover if it has cell actions,
      // otherwise keyboard and screen reader users have no way of accessing them
      if ((_this$props$column = _this.props.column) !== null && _this$props$column !== void 0 && (_this$props$column = _this$props$column.cellActions) !== null && _this$props$column !== void 0 && _this$props$column.length) return true;

      // props.isExpandable inherits from column.isExpandable
      // state.cellProps allows consuming applications to override isExpandable on a per-cell basis
      return (_this$state$cellProps = _this.state.cellProps.isExpandable) !== null && _this$state$cellProps !== void 0 ? _this$state$cellProps : _this.props.isExpandable;
    });
    _defineProperty(_this, "isPopoverOpen", function () {
      var _this$props$popoverCo = _this.props.popoverContext,
        popoverIsOpen = _this$props$popoverCo.popoverIsOpen,
        cellLocation = _this$props$popoverCo.cellLocation;
      return _this.isExpandable() && popoverIsOpen && cellLocation.colIndex === _this.props.colIndex && cellLocation.rowIndex === _this.props.visibleRowIndex;
    });
    _defineProperty(_this, "handleCellPopover", function () {
      if (_this.isPopoverOpen()) {
        var _this$props$popoverCo2 = _this.props.popoverContext,
          setPopoverAnchor = _this$props$popoverCo2.setPopoverAnchor,
          setPopoverAnchorPosition = _this$props$popoverCo2.setPopoverAnchorPosition,
          setPopoverContent = _this$props$popoverCo2.setPopoverContent,
          setCellPopoverProps = _this$props$popoverCo2.setCellPopoverProps;

        // Set popover anchor
        var cellAnchorEl = _this.popoverAnchorRef.current;
        setPopoverAnchor(cellAnchorEl);
        // TODO: Potentially switch to `topLeft` based on occlusion with sticky header
        // @see https://github.com/elastic/eui/issues/7828
        setPopoverAnchorPosition('downLeft');

        // Set popover contents with cell content
        var _this$props5 = _this.props,
          renderCellPopover = _this$props5.renderCellPopover,
          renderCellValue = _this$props5.renderCellValue,
          cellContext = _this$props5.cellContext,
          rowIndex = _this$props5.rowIndex,
          colIndex = _this$props5.colIndex,
          column = _this$props5.column,
          columnId = _this$props5.columnId,
          columnType = _this$props5.columnType;
        var PopoverElement = renderCellPopover || DefaultCellPopover;
        var CellElement = renderCellValue;
        var sharedProps = {
          rowIndex: rowIndex,
          colIndex: colIndex,
          columnId: columnId,
          schema: (column === null || column === void 0 ? void 0 : column.schema) || columnType
        };
        var popoverContent = ___EmotionJSX(PopoverElement, _extends({}, sharedProps, {
          cellContentsElement: _this.cellContentsRef,
          cellActions: ___EmotionJSX(EuiDataGridCellPopoverActions, _extends({}, sharedProps, {
            column: column
          })),
          DefaultCellPopover: DefaultCellPopover,
          setCellPopoverProps: setCellPopoverProps
        }), ___EmotionJSX(CellElement, _extends({}, cellContext, sharedProps, {
          setCellProps: _this.setCellProps,
          isExpandable: true,
          isExpanded: true,
          isDetails: true
        })));
        setPopoverContent(popoverContent);
      }
    });
    _defineProperty(_this, "handleCellKeyDown", function (event) {
      if (_this.isExpandable()) {
        if (_this.isPopoverOpen()) return;
        var _this$props6 = _this.props,
          openCellPopover = _this$props6.popoverContext.openCellPopover,
          visibleRowIndex = _this$props6.visibleRowIndex,
          colIndex = _this$props6.colIndex;
        switch (event.key) {
          case keys.ENTER:
          case keys.F2:
            event.preventDefault();
            openCellPopover({
              rowIndex: visibleRowIndex,
              colIndex: colIndex
            });
            break;
        }
      }
    });
    _defineProperty(_this, "handleCellExpansionClick", function () {
      var _this$props7 = _this.props,
        _this$props7$popoverC = _this$props7.popoverContext,
        openCellPopover = _this$props7$popoverC.openCellPopover,
        closeCellPopover = _this$props7$popoverC.closeCellPopover,
        visibleRowIndex = _this$props7.visibleRowIndex,
        colIndex = _this$props7.colIndex;
      if (_this.isPopoverOpen()) {
        closeCellPopover();
      } else {
        openCellPopover({
          rowIndex: visibleRowIndex,
          colIndex: colIndex
        });
      }
    });
    _defineProperty(_this, "onMouseEnter", function () {
      return _this.setState({
        isHovered: true
      });
    });
    _defineProperty(_this, "onMouseLeave", function () {
      return _this.setState({
        isHovered: false
      });
    });
    return _this;
  }
  _inherits(EuiDataGridCell, _Component);
  return _createClass(EuiDataGridCell, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props8 = this.props,
        colIndex = _this$props8.colIndex,
        visibleRowIndex = _this$props8.visibleRowIndex;
      this.unsubscribeCell = this.context.onFocusUpdate([colIndex, visibleRowIndex], this.onFocusUpdate);

      // Account for virtualization - when a cell unmounts when scrolled out of view
      // and then remounts when scrolled back into view, it should retain focus state
      if (this.isFocusedCell()) {
        // The second flag sets preventScroll: true as a focus option, which prevents
        // hijacking the user's scroll behavior when the cell re-mounts on scroll
        this.onFocusUpdate(true, true);
        this.context.setIsFocusedCellInView(true);
      }

      // Check if popover should be open on mount (typically only occurs if
      // openCellPopover() is manually called on a location that's out of view)
      this.handleCellPopover();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.unsubscribeCell) {
        this.unsubscribeCell();
      }
      if (this.isFocusedCell()) {
        this.context.setIsFocusedCellInView(false);
      }
      if (this.isPopoverOpen()) {
        this.props.popoverContext.closeCellPopover();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props$rowHeight, _prevProps$rowHeights, _this$props$rowHeight2, _prevProps$rowHeights2, _this$props$rowHeight3, _prevProps$rowHeights3, _this$props$gridStyle, _prevProps$gridStyles, _this$props$gridStyle2, _prevProps$gridStyles2, _this$props$rowHeight4, _this$props$rowHeight5, _this$props$style, _prevProps$style;
      this.recalculateAutoHeight();
      if (((_this$props$rowHeight = this.props.rowHeightsOptions) === null || _this$props$rowHeight === void 0 ? void 0 : _this$props$rowHeight.defaultHeight) !== ((_prevProps$rowHeights = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights === void 0 ? void 0 : _prevProps$rowHeights.defaultHeight) || ((_this$props$rowHeight2 = this.props.rowHeightsOptions) === null || _this$props$rowHeight2 === void 0 || (_this$props$rowHeight2 = _this$props$rowHeight2.rowHeights) === null || _this$props$rowHeight2 === void 0 ? void 0 : _this$props$rowHeight2[this.props.rowIndex]) !== ((_prevProps$rowHeights2 = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights2 === void 0 || (_prevProps$rowHeights2 = _prevProps$rowHeights2.rowHeights) === null || _prevProps$rowHeights2 === void 0 ? void 0 : _prevProps$rowHeights2[prevProps.rowIndex]) || ((_this$props$rowHeight3 = this.props.rowHeightsOptions) === null || _this$props$rowHeight3 === void 0 ? void 0 : _this$props$rowHeight3.lineHeight) !== ((_prevProps$rowHeights3 = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights3 === void 0 ? void 0 : _prevProps$rowHeights3.lineHeight) || ((_this$props$gridStyle = this.props.gridStyles) === null || _this$props$gridStyle === void 0 ? void 0 : _this$props$gridStyle.fontSize) !== ((_prevProps$gridStyles = prevProps.gridStyles) === null || _prevProps$gridStyles === void 0 ? void 0 : _prevProps$gridStyles.fontSize) || ((_this$props$gridStyle2 = this.props.gridStyles) === null || _this$props$gridStyle2 === void 0 ? void 0 : _this$props$gridStyle2.cellPadding) !== ((_prevProps$gridStyles2 = prevProps.gridStyles) === null || _prevProps$gridStyles2 === void 0 ? void 0 : _prevProps$gridStyles2.cellPadding)) {
        this.recalculateLineHeight();
      }
      if ((_this$props$rowHeight4 = this.props.rowHeightUtils) !== null && _this$props$rowHeight4 !== void 0 && _this$props$rowHeight4.compensateForLayoutShift && (_this$props$rowHeight5 = this.props.rowHeightsOptions) !== null && _this$props$rowHeight5 !== void 0 && _this$props$rowHeight5.scrollAnchorRow && this.props.colIndex === 0 &&
      // once per row
      this.props.columnId === prevProps.columnId &&
      // if this is still the same column
      this.props.rowIndex === prevProps.rowIndex &&
      // if this is still the same row
      ((_this$props$style = this.props.style) === null || _this$props$style === void 0 ? void 0 : _this$props$style.top) !== ((_prevProps$style = prevProps.style) === null || _prevProps$style === void 0 ? void 0 : _prevProps$style.top) // if the top position has changed
      ) {
        var _prevProps$style2, _this$props$style2, _this$props$rowHeight6;
        var previousTop = parseFloat((_prevProps$style2 = prevProps.style) === null || _prevProps$style2 === void 0 ? void 0 : _prevProps$style2.top);
        var currentTop = parseFloat((_this$props$style2 = this.props.style) === null || _this$props$style2 === void 0 ? void 0 : _this$props$style2.top);

        // @ts-ignore We've already checked that this virtualization util is available above
        this.props.rowHeightUtils.compensateForLayoutShift(this.props.rowIndex, currentTop - previousTop, (_this$props$rowHeight6 = this.props.rowHeightsOptions) === null || _this$props$rowHeight6 === void 0 ? void 0 : _this$props$rowHeight6.scrollAnchorRow);
      }
      if (this.props.popoverContext.popoverIsOpen !== prevProps.popoverContext.popoverIsOpen || this.props.popoverContext.cellLocation !== prevProps.popoverContext.cellLocation || this.props.renderCellPopover !== prevProps.renderCellPopover) {
        this.handleCellPopover();
      }
      if (this.props.columnId !== prevProps.columnId || this.props.rowIndex !== prevProps.rowIndex) {
        this.setCellProps({});
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      var _nextProps$gridStyles, _this$props$gridStyle3, _nextProps$gridStyles2, _this$props$gridStyle4;
      if (nextProps.rowIndex !== this.props.rowIndex) return true;
      if (nextProps.visibleRowIndex !== this.props.visibleRowIndex) return true;
      if (nextProps.colIndex !== this.props.colIndex) return true;
      if (nextProps.columnId !== this.props.columnId) return true;
      if (nextProps.columnType !== this.props.columnType) return true;
      if (nextProps.width !== this.props.width) return true;
      if (nextProps.rowHeightsOptions !== this.props.rowHeightsOptions) return true;
      if (((_nextProps$gridStyles = nextProps.gridStyles) === null || _nextProps$gridStyles === void 0 ? void 0 : _nextProps$gridStyles.fontSize) !== ((_this$props$gridStyle3 = this.props.gridStyles) === null || _this$props$gridStyle3 === void 0 ? void 0 : _this$props$gridStyle3.fontSize)) return true;
      if (((_nextProps$gridStyles2 = nextProps.gridStyles) === null || _nextProps$gridStyles2 === void 0 ? void 0 : _nextProps$gridStyles2.cellPadding) !== ((_this$props$gridStyle4 = this.props.gridStyles) === null || _this$props$gridStyle4 === void 0 ? void 0 : _this$props$gridStyle4.cellPadding)) return true;
      if (nextProps.renderCellValue !== this.props.renderCellValue) return true;
      if (nextProps.renderCellPopover !== this.props.renderCellPopover) return true;
      if (nextProps.interactiveCellId !== this.props.interactiveCellId) return true;
      if (nextProps.popoverContext.popoverIsOpen !== this.props.popoverContext.popoverIsOpen || nextProps.popoverContext.cellLocation !== this.props.popoverContext.cellLocation) return true;

      // respond to adjusted position & dimensions
      if (nextProps.style) {
        if (!this.props.style) return true;
        if (nextProps.style.top !== this.props.style.top) {
          return true;
        }
        if (nextProps.style.left !== this.props.style.left) return true;
        if (nextProps.style.height !== this.props.style.height) return true;
        if (nextProps.style.width !== this.props.style.width) return true;
      }
      if (nextProps.cellContext !== this.props.cellContext) return true;
      if (nextState.cellProps !== this.state.cellProps) return true;
      if (nextState.isFocused !== this.state.isFocused) return true;
      if (nextState.isHovered !== this.state.isHovered) return true;
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      var _rowHeightsOptions$li;
      var _this$props9 = this.props,
        width = _this$props9.width,
        popoverContext = _this$props9.popoverContext,
        interactiveCellId = _this$props9.interactiveCellId,
        columnType = _this$props9.columnType,
        className = _this$props9.className,
        column = _this$props9.column,
        style = _this$props9.style,
        rowHeightUtils = _this$props9.rowHeightUtils,
        rowHeightsOptions = _this$props9.rowHeightsOptions,
        rowManager = _this$props9.rowManager,
        pagination = _this$props9.pagination,
        rest = _objectWithoutProperties(_this$props9, _excluded2);
      var rowIndex = rest.rowIndex,
        visibleRowIndex = rest.visibleRowIndex,
        colIndex = rest.colIndex;
      var isExpandable = this.isExpandable();
      var popoverIsOpen = this.isPopoverOpen();
      var showCellActions = isExpandable && (popoverIsOpen || this.state.isFocused || this.state.isHovered);
      var cellClasses = classNames('euiDataGridRowCell', _defineProperty(_defineProperty({}, "euiDataGridRowCell--".concat(columnType), columnType), 'euiDataGridRowCell--open', popoverIsOpen), className);

      // classNames set by EuiDataGridCellWrapper
      var isControlColumn = cellClasses.includes('euiDataGridRowCell--controlColumn');
      var isLastColumn = cellClasses.includes('euiDataGridRowCell--lastColumn');
      var ariaRowIndex = pagination ? visibleRowIndex + 1 + pagination.pageSize * pagination.pageIndex : visibleRowIndex + 1;
      var _this$state$cellProps2 = this.state.cellProps,
        _ = _this$state$cellProps2.isExpandable,
        cellPropsStyle = _this$state$cellProps2.style,
        cellPropsClassName = _this$state$cellProps2.className,
        cellPropsDataTestSubj = _this$state$cellProps2['data-test-subj'],
        setCellProps = _objectWithoutProperties(_this$state$cellProps2, _excluded3);
      var cellProps = _objectSpread(_objectSpread({}, setCellProps), {}, {
        'data-test-subj': classNames('dataGridRowCell', cellPropsDataTestSubj),
        className: classNames(cellClasses, cellPropsClassName)
      });
      cellProps.style = _objectSpread(_objectSpread({}, style), {}, {
        // set by react-window or the custom renderer
        top: style !== null && style !== void 0 && style.top ? 0 : undefined,
        // The cell's row will handle top positioning
        width: width,
        // column width, can be undefined
        lineHeight: (_rowHeightsOptions$li = rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.lineHeight) !== null && _rowHeightsOptions$li !== void 0 ? _rowHeightsOptions$li : undefined
      }, cellPropsStyle);
      var row = rowManager && !IS_JEST_ENVIRONMENT ? rowManager.getRow({
        rowIndex: rowIndex,
        visibleRowIndex: visibleRowIndex,
        top: style.top,
        // comes in as a `{float}px` string from react-window
        height: style.height // comes in as an integer from react-window
      }) : undefined;
      return ___EmotionJSX(RenderCellInRow, {
        row: row
      }, ___EmotionJSX(GridCellDiv, _extends({}, cellProps, {
        ref: this.cellRef,
        columnId: this.props.columnId,
        columnIndex: this.props.colIndex,
        rowIndex: rowIndex,
        visibleRowIndex: this.props.visibleRowIndex,
        "aria-rowindex": ariaRowIndex,
        tabIndex: this.state.isFocused ? 0 : -1,
        onKeyDown: this.handleCellKeyDown,
        onMouseEnter: this.onMouseEnter,
        onMouseLeave: this.onMouseLeave
      }), ___EmotionJSX(HandleInteractiveChildren, {
        cellEl: this.cellRef.current,
        updateCellFocusContext: this.updateCellFocusContext,
        renderFocusTrap: !isExpandable
      }, ___EmotionJSX(EuiDataGridCellContent, _extends({}, rest, {
        setCellProps: this.setCellProps,
        column: column,
        columnType: columnType,
        isExpandable: isExpandable,
        isExpanded: popoverIsOpen,
        setCellContentsRef: this.setCellContentsRef,
        rowHeightsOptions: rowHeightsOptions,
        rowHeightUtils: rowHeightUtils,
        isControlColumn: isControlColumn,
        rowIndex: rowIndex,
        colIndex: colIndex
      }))), isLastColumn ? tabularCopyMarkers.hiddenNewline : tabularCopyMarkers.hiddenTab, this.state.isFocused && ___EmotionJSX(CellScreenReaderDescription, {
        columnName: (column === null || column === void 0 ? void 0 : column.displayAsText) || this.props.columnId,
        columnIndex: colIndex + 1,
        rowIndex: ariaRowIndex,
        canExpandCell: showCellActions
      }), showCellActions && ___EmotionJSX(EuiDataGridCellActions, {
        rowIndex: rowIndex,
        colIndex: colIndex,
        column: column,
        onExpandClick: this.handleCellExpansionClick,
        popoverAnchorRef: this.popoverAnchorRef
      })));
    }
  }]);
}(Component);

/**
 * Function component utilities for conditional rendering.
 * Used for DRYness and performance
 */
_defineProperty(EuiDataGridCell, "contextType", DataGridFocusContext);
var RenderCellInRow = /*#__PURE__*/memo(function (_ref2) {
  var row = _ref2.row,
    children = _ref2.children;
  return row ? /*#__PURE__*/createPortal(children, row) : children;
});
RenderCellInRow.displayName = 'RenderCellInRow';
var RenderTruncatedCellContent = /*#__PURE__*/memo(function (_ref3) {
  var children = _ref3.children,
    hasLineCountTruncation = _ref3.hasLineCountTruncation,
    rowHeight = _ref3.rowHeight;
  // If `hasLineCountTruncation` is true, we can rely on rowHeight being the correct type
  var lines = hasLineCountTruncation ? rowHeight.lineCount : undefined;
  return lines ? ___EmotionJSX(EuiTextBlockTruncate, {
    lines: lines,
    cloneElement: true
  }, children) : children;
});
RenderTruncatedCellContent.displayName = 'RenderTruncatedCellContent';

/**
 * Function component utilities for easier hook usage
 */

var GridCellDiv = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref4, ref) {
  var columnId = _ref4.columnId,
    columnIndex = _ref4.columnIndex,
    rowIndex = _ref4.rowIndex,
    visibleRowIndex = _ref4.visibleRowIndex,
    props = _objectWithoutProperties(_ref4, _excluded4);
  var styles = useEuiMemoizedStyles(euiDataGridRowCellStyles);
  return ___EmotionJSX("div", _extends({
    ref: ref,
    css: styles.euiDataGridRowCell
  }, props, {
    role: "gridcell"
    // Data attributes to help target specific cells by either data or current cell location
    ,
    "data-gridcell-column-id": columnId // Static column ID name, not affected by column order
    ,
    "data-gridcell-column-index": columnIndex // Affected by column reordering
    ,
    "data-gridcell-row-index": rowIndex // Index from data, not affected by sorting or pagination
    ,
    "data-gridcell-visible-row-index": visibleRowIndex // Affected by sorting & pagination
  }));
}));
GridCellDiv.displayName = 'GridCellDiv';
var CellScreenReaderDescription = /*#__PURE__*/memo(function (_ref5) {
  var columnName = _ref5.columnName,
    columnIndex = _ref5.columnIndex,
    rowIndex = _ref5.rowIndex,
    canExpandCell = _ref5.canExpandCell;
  var cellPosition = useEuiI18n('euiDataGridCell.position', '{columnName}, column {columnIndex}, row {rowIndex}', {
    columnName: columnName,
    columnIndex: columnIndex,
    rowIndex: rowIndex
  });
  var enterKeyPrompt = useEuiI18n('euiDataGridCell.expansionEnterPrompt', 'Press the Enter key to expand this cell.');
  return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, tabularCopyMarkers.hiddenNoCopyBoundary, " - ".concat(cellPosition).concat(canExpandCell ? ". ".concat(enterKeyPrompt) : ''), tabularCopyMarkers.hiddenNoCopyBoundary));
});
CellScreenReaderDescription.displayName = 'CellScreenReaderDescription';