import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { euiCanAnimate, logicalCSS, logicalSizeCSS, mathWithUnits } from '../../../../global_styling';
import { euiDataGridVariables } from '../../data_grid.styles';
import { euiDataGridCellOutlineStyles, euiDataGridCellOutlineSelectors } from './data_grid_cell.styles';
export var euiDataGridCellActionsStyles = function euiDataGridCellActionsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  var borderWidth = euiTheme.border.width.thin;
  var cellOutline = euiDataGridCellOutlineStyles(euiThemeContext);
  var _euiDataGridCellOutli = euiDataGridCellOutlineSelectors('.euiDataGridRowCell'),
    cellSelectors = _euiDataGridCellOutli.actions;
  return {
    euiDataGridRowCell__actionsWrapper: /*#__PURE__*/css("position:absolute;", logicalCSS('left', 0), " ", logicalCSS('bottom', '100%'), "z-index:", levels.stickyHeader - 1, ";.euiDataGridRowCell[data-gridcell-visible-row-index='0']>&{z-index:", levels.stickyHeader + 1, ";}", cellSelectors.hoverZone, " &{", logicalCSS('min-width', '50%'), " ", logicalCSS('padding-right', euiTheme.size.base), ";};label:euiDataGridRowCell__actionsWrapper;"),
    euiDataGridRowCell__actions: /*#__PURE__*/css("position:relative;display:flex;gap:", euiTheme.size.xxs, ";", logicalCSS('width', 'fit-content'), " padding-inline:", euiTheme.size.xxs, ";", logicalCSS('margin-bottom', "-".concat(borderWidth)), " background-color:", cellOutline.focusColor, ";color:", euiTheme.colors.emptyShade, ";border:", borderWidth, " solid ", cellOutline.focusColor, ";border-radius:", cellOutline.borderRadius, ";", logicalCSS('border-bottom-left-radius', 0), "&::after{content:'';position:absolute;", logicalCSS('top', '100%'), " ", logicalCSS('left', "-".concat(borderWidth)), " ", logicalSizeCSS(mathWithUnits(borderWidth, function (x) {
      return x * 2;
    })), " background-color:inherit;}", cellSelectors.hoverColor, " &{background-color:", cellOutline.hoverColor, ";border-color:", cellOutline.hoverColor, ";}", euiCanAnimate, "{transform:scaleY(0);transform-origin:bottom;", cellSelectors.showAnimation, " &{animation-duration:", euiTheme.animation.fast, ";animation-name:", slideUp, ";animation-iteration-count:1;animation-fill-mode:forwards;}", cellSelectors.hoverAnimation, " &{animation-delay:", euiTheme.animation.slow, ";}};label:euiDataGridRowCell__actions;"),
    euiDataGridRowCell__actionButtonIcon: /*#__PURE__*/css(logicalCSS('width', euiTheme.size.base), " ", logicalCSS('height', mathWithUnits([euiTheme.size.base, euiTheme.size.xs], function (x, y) {
      return x + y;
    })), " border-radius:0;&,svg{background-color:transparent!important;color:currentColor!important;fill:currentColor!important;}&.euiDataGridRowCell__expandCell .euiIcon{", logicalCSS('width', '120%'), " ", logicalCSS('height', '100%'), ";};label:euiDataGridRowCell__actionButtonIcon;")
  };
};
var slideUp = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from { transform: scaleY(0); }\n  to { transform: scaleY(1); }\n"])));