import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["colIndex", "visibleRowIndex", "style", "schema", "schemaDetectors", "pagination", "columns", "leadingControlColumns", "trailingControlColumns", "visibleColCount", "columnWidths", "defaultColumnWidth", "renderCellValue", "cellContext", "renderCellPopover", "interactiveCellId", "setRowHeight", "rowHeightsOptions", "rowHeightUtils", "rowManager"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useMemo, memo } from 'react';
import classNames from 'classnames';
import { DataGridSortedContext } from '../../utils/sorting';
import { DataGridCellPopoverContext } from './data_grid_cell_popover';
import { EuiDataGridCell } from './data_grid_cell';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * A DRY wrapper used by both custom and virtualized grid cells.
 * It grabs context,  determines the type of cell being rendered
 * (e.g. control vs data cell), & sets shared props between all cells
 */
export var CellWrapper = /*#__PURE__*/memo(function (_ref) {
  var colIndex = _ref.colIndex,
    visibleRowIndex = _ref.visibleRowIndex,
    style = _ref.style,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    pagination = _ref.pagination,
    columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    visibleColCount = _ref.visibleColCount,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    renderCellPopover = _ref.renderCellPopover,
    interactiveCellId = _ref.interactiveCellId,
    setRowHeight = _ref.setRowHeight,
    rowHeightsOptions = _ref.rowHeightsOptions,
    rowHeightUtils = _ref.rowHeightUtils,
    rowManager = _ref.rowManager,
    rest = _objectWithoutProperties(_ref, _excluded);
  var popoverContext = useContext(DataGridCellPopoverContext);
  var _useContext = useContext(DataGridSortedContext),
    getCorrectRowIndex = _useContext.getCorrectRowIndex;
  var isFirstColumn = colIndex === 0;
  var isLastColumn = colIndex === visibleColCount - 1;
  var isLeadingControlColumn = colIndex < leadingControlColumns.length;
  var isTrailingControlColumn = colIndex >= leadingControlColumns.length + columns.length;
  var datacolIndex = colIndex - leadingControlColumns.length;
  var column = columns[datacolIndex];
  var columnId = column === null || column === void 0 ? void 0 : column.id;
  var textTransform = useMemo(function () {
    var _schemaDetectors$filt;
    return (_schemaDetectors$filt = schemaDetectors.filter(function (row) {
      return column !== null && column !== void 0 && column.schema ? (column === null || column === void 0 ? void 0 : column.schema) === row.type : columnId === row.type;
    })[0]) === null || _schemaDetectors$filt === void 0 ? void 0 : _schemaDetectors$filt.textTransform;
  }, [columnId, column === null || column === void 0 ? void 0 : column.schema, schemaDetectors]);
  var sharedCellProps = useMemo(function () {
    var classes = classNames(_defineProperty({
      'euiDataGridRowCell--firstColumn': isFirstColumn,
      'euiDataGridRowCell--lastColumn': isLastColumn,
      'euiDataGridRowCell--controlColumn': isLeadingControlColumn || isTrailingControlColumn
    }, "euiDataGridRowCell--".concat(textTransform), textTransform));
    return {
      rowIndex: getCorrectRowIndex(visibleRowIndex),
      visibleRowIndex: visibleRowIndex,
      colIndex: colIndex,
      interactiveCellId: interactiveCellId,
      className: classes,
      style: style,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      setRowHeight: isFirstColumn ? setRowHeight : undefined,
      rowManager: rowManager,
      popoverContext: popoverContext,
      pagination: pagination,
      cellContext: cellContext
    };
  }, [colIndex, setRowHeight, visibleRowIndex, getCorrectRowIndex, interactiveCellId, style, rowHeightsOptions, rowHeightUtils, rowManager, popoverContext, pagination, cellContext, isFirstColumn, isLastColumn, isLeadingControlColumn, isTrailingControlColumn, textTransform]);
  if (isLeadingControlColumn) {
    var leadingColumn = leadingControlColumns[colIndex];
    var id = leadingColumn.id,
      rowCellRender = leadingColumn.rowCellRender;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: id,
      width: leadingColumn.width,
      renderCellValue: rowCellRender,
      isExpandable: false
    }, rest));
  } else if (isTrailingControlColumn) {
    var columnOffset = columns.length + leadingControlColumns.length;
    var trailingcolIndex = colIndex - columnOffset;
    var trailingColumn = trailingControlColumns[trailingcolIndex];
    var _id = trailingColumn.id,
      _rowCellRender = trailingColumn.rowCellRender;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: _id,
      width: trailingColumn.width,
      renderCellValue: _rowCellRender,
      isExpandable: false
    }, rest));
  } else {
    // this is a normal data cell
    var columnType = schema[columnId] ? schema[columnId].columnType : null;
    var isExpandable = (column === null || column === void 0 ? void 0 : column.isExpandable) !== undefined ? column === null || column === void 0 ? void 0 : column.isExpandable : true;
    var width = columnWidths[columnId] || defaultColumnWidth;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, sharedCellProps, {
      columnId: columnId,
      column: column,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      isExpandable: isExpandable
    }, rest));
  }
});
CellWrapper.displayName = 'CellWrapper';