import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["renderCustomGridBody"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiDataGridBodyVirtualized } from './data_grid_body_virtualized';
import { EuiDataGridBodyCustomRender } from './data_grid_body_custom';
import { euiDataGridBodyStyles } from './data_grid_body.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridBody = function EuiDataGridBody(_ref) {
  var renderCustomGridBody = _ref.renderCustomGridBody,
    props = _objectWithoutProperties(_ref, _excluded);
  /*
   * Determine whether we should use the default EuiDataGridBody
   * + virtualization library for rendering content, or if consumers have
   * passed their own custom renderer
   */
  var styles = useEuiMemoizedStyles(euiDataGridBodyStyles);
  var cssStyles = [styles.euiDataGridBody, renderCustomGridBody ? styles.customRender : styles.virtualized];
  return renderCustomGridBody ? ___EmotionJSX(EuiDataGridBodyCustomRender, _extends({
    renderCustomGridBody: renderCustomGridBody,
    css: cssStyles
  }, props)) : ___EmotionJSX(EuiDataGridBodyVirtualized, _extends({
    css: cssStyles
  }, props));
};