import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
var _excluded = ["colIndex", "visibleRowIndex"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, memo } from 'react';
import classNames from 'classnames';
import { useDefaultColumnWidth, useColumnWidths } from '../utils/col_widths';
import { useRowHeightUtils, useDefaultRowHeight } from '../utils/row_heights';
import { useDataGridHeader } from './header';
import { useDataGridFooter } from './footer';
import { CellWrapper } from './cell';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridBodyCustomRender = /*#__PURE__*/memo(function (_ref) {
  var renderCustomGridBody = _ref.renderCustomGridBody,
    renderCellValue = _ref.renderCellValue,
    cellContext = _ref.cellContext,
    renderCellPopover = _ref.renderCellPopover,
    renderFooterCellValue = _ref.renderFooterCellValue,
    interactiveCellId = _ref.interactiveCellId,
    visibleRows = _ref.visibleRows,
    visibleColCount = _ref.visibleColCount,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    columns = _ref.columns,
    setVisibleColumns = _ref.setVisibleColumns,
    switchColumnPos = _ref.switchColumnPos,
    canDragAndDropColumns = _ref.canDragAndDropColumns,
    onColumnResize = _ref.onColumnResize,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    sorting = _ref.sorting,
    pagination = _ref.pagination,
    rowHeightsOptions = _ref.rowHeightsOptions,
    gridWidth = _ref.gridWidth,
    gridStyles = _ref.gridStyles,
    className = _ref.className;
  /**
   * Columns & widths
   */
  var visibleColumns = useMemo(function () {
    return [].concat(_toConsumableArray(leadingControlColumns), _toConsumableArray(columns), _toConsumableArray(trailingControlColumns));
  }, [columns, leadingControlColumns, trailingControlColumns]);

  // compute the default column width from the container's width and count of visible columns
  var defaultColumnWidth = useDefaultColumnWidth(gridWidth, leadingControlColumns, trailingControlColumns, columns);
  var _useColumnWidths = useColumnWidths({
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      defaultColumnWidth: defaultColumnWidth,
      onColumnResize: onColumnResize
    }),
    columnWidths = _useColumnWidths.columnWidths,
    setColumnWidth = _useColumnWidths.setColumnWidth;

  /**
   * Row heights
   */
  var rowHeightUtils = useRowHeightUtils({
    rowHeightsOptions: rowHeightsOptions,
    columns: columns
  });
  var _useDefaultRowHeight = useDefaultRowHeight({
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils
    }),
    setRowHeight = _useDefaultRowHeight.setRowHeight,
    getRowHeight = _useDefaultRowHeight.getRowHeight;
  var headerRowProps = useMemo(function () {
    return {
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      visibleColCount: visibleColCount,
      switchColumnPos: switchColumnPos,
      canDragAndDropColumns: canDragAndDropColumns,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      gridStyles: gridStyles
    };
  }, [leadingControlColumns, trailingControlColumns, columns, columnWidths, defaultColumnWidth, setColumnWidth, visibleColCount, setVisibleColumns, switchColumnPos, canDragAndDropColumns, sorting, schema, schemaDetectors, gridStyles]);

  /**
   * Header & footer
   */
  var _useDataGridHeader = useDataGridHeader(headerRowProps),
    headerRow = _useDataGridHeader.headerRow;
  var footerRowProps = useMemo(function () {
    return {
      renderFooterCellValue: renderFooterCellValue,
      renderCellPopover: renderCellPopover,
      rowIndex: visibleRows.visibleRowCount,
      visibleRowIndex: visibleRows.visibleRowCount,
      visibleColCount: visibleColCount,
      interactiveCellId: interactiveCellId,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      schema: schema,
      gridStyles: gridStyles
    };
  }, [renderFooterCellValue, renderCellPopover, visibleRows.visibleRowCount, visibleColCount, interactiveCellId, leadingControlColumns, trailingControlColumns, columns, columnWidths, defaultColumnWidth, schema, gridStyles]);
  var _useDataGridFooter = useDataGridFooter(footerRowProps),
    footerRow = _useDataGridFooter.footerRow;

  /**
   * Cell render fn
   */
  var cellProps = useMemo(function () {
    return {
      schema: schema,
      schemaDetectors: schemaDetectors,
      pagination: pagination,
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      visibleColCount: visibleColCount,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      renderCellValue: renderCellValue,
      cellContext: cellContext,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      setRowHeight: setRowHeight,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      gridStyles: gridStyles
    };
  }, [schema, schemaDetectors, pagination, columns, leadingControlColumns, trailingControlColumns, visibleColCount, columnWidths, defaultColumnWidth, renderCellValue, cellContext, renderCellPopover, interactiveCellId, setRowHeight, rowHeightsOptions, rowHeightUtils, gridStyles]);
  var Cell = useMemo(function () {
    return function (_ref2) {
      var _rest$rowHeightsOptio;
      var colIndex = _ref2.colIndex,
        visibleRowIndex = _ref2.visibleRowIndex,
        rest = _objectWithoutProperties(_ref2, _excluded);
      var style = {
        height: rowHeightUtils.isAutoHeight(visibleRowIndex, (_rest$rowHeightsOptio = rest.rowHeightsOptions) !== null && _rest$rowHeightsOptio !== void 0 ? _rest$rowHeightsOptio : rowHeightsOptions) ? 'auto' : getRowHeight(visibleRowIndex)
      };
      var props = _objectSpread({
        colIndex: colIndex,
        visibleRowIndex: visibleRowIndex,
        style: style
      }, cellProps);
      return ___EmotionJSX(CellWrapper, _extends({}, props, rest));
    };
  }, [cellProps, getRowHeight, rowHeightUtils, rowHeightsOptions]);

  // Allow consumers to pass custom props/attributes/listeners etc. to the wrapping div
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    customGridBodyProps = _useState2[0],
    setCustomGridBodyProps = _useState2[1];
  var customDataGridBodyProps = useMemo(function () {
    return {
      gridWidth: gridWidth,
      visibleColumns: visibleColumns,
      visibleRowData: visibleRows,
      Cell: Cell,
      setCustomGridBodyProps: setCustomGridBodyProps,
      headerRow: headerRow,
      footerRow: footerRow
    };
  }, [gridWidth, visibleColumns, visibleRows, Cell, setCustomGridBodyProps, headerRow, footerRow]);
  var BodyElement = renderCustomGridBody;
  return ___EmotionJSX("div", _extends({}, customGridBodyProps, {
    className: classNames('euiDataGrid__customRenderBody', className, customGridBodyProps === null || customGridBodyProps === void 0 ? void 0 : customGridBodyProps.className)
  }), ___EmotionJSX(BodyElement, customDataGridBodyProps));
});
EuiDataGridBodyCustomRender.displayName = 'EuiDataGridBodyCustomRender';