import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React, { forwardRef, createContext, useCallback, useContext, useEffect, useRef, useMemo, memo } from 'react';
import { VariableSizeGrid as Grid } from 'react-window';
import { useDeepEqual } from '../../../services';
import { useResizeObserver } from '../../observer/resize_observer';
import { useDataGridHeader } from './header';
import { useDataGridFooter } from './footer';
import { CellWrapper } from './cell';
import { useRowManager } from './data_grid_row_manager';
import { useFinalGridDimensions, useUnconstrainedHeight, useVirtualizeContainerWidth } from '../utils/grid_height_width';
import { useDefaultColumnWidth, useColumnWidths } from '../utils/col_widths';
import { useRowHeightUtils, useDefaultRowHeight } from '../utils/row_heights';
import { useScrollBars, useScroll } from '../utils/scrolling';
import { IS_JEST_ENVIRONMENT } from '../../../utils';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var Cell = /*#__PURE__*/memo(function (_ref) {
  var columnIndex = _ref.columnIndex,
    rowIndex = _ref.rowIndex,
    style = _ref.style,
    data = _ref.data;
  var memoizedStyles = useDeepEqual(style);
  var cellStyles = useMemo(function () {
    var headerRowHeight = data.headerRowHeight;
    return _objectSpread(_objectSpread({}, memoizedStyles), {}, {
      top: "".concat(parseFloat(memoizedStyles.top) + headerRowHeight, "px")
    });
  }, [memoizedStyles, data]);
  return ___EmotionJSX(CellWrapper, _extends({
    colIndex: columnIndex,
    visibleRowIndex: rowIndex,
    style: cellStyles
  }, data));
});
Cell.displayName = 'Cell';

// Context is required to pass props to react-window's innerElementType
// @see https://github.com/bvaughn/react-window/issues/404
export var DataGridWrapperRowsContext = /*#__PURE__*/createContext({
  headerRow: ___EmotionJSX("div", null),
  headerRowHeight: 0,
  footerRow: null
});
var InnerElement = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var children = _ref2.children,
    style = _ref2.style,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var _useContext = useContext(DataGridWrapperRowsContext),
    headerRowHeight = _useContext.headerRowHeight,
    headerRow = _useContext.headerRow,
    footerRow = _useContext.footerRow;
  var memoizedStyles = useDeepEqual(style);
  var innerElementStyles = useMemo(function () {
    return _objectSpread(_objectSpread({}, memoizedStyles), {}, {
      height: memoizedStyles.height + headerRowHeight
    });
  }, [memoizedStyles, headerRowHeight]);
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX("div", _extends({
    ref: ref,
    style: innerElementStyles
  }, rest), headerRow, children), footerRow);
}));
InnerElement.displayName = 'EuiDataGridInnerElement';
export var EuiDataGridBodyVirtualized = /*#__PURE__*/memo(function (_ref3) {
  var leadingControlColumns = _ref3.leadingControlColumns,
    trailingControlColumns = _ref3.trailingControlColumns,
    columns = _ref3.columns,
    visibleColCount = _ref3.visibleColCount,
    schema = _ref3.schema,
    schemaDetectors = _ref3.schemaDetectors,
    rowCount = _ref3.rowCount,
    _ref3$visibleRows = _ref3.visibleRows,
    startRow = _ref3$visibleRows.startRow,
    endRow = _ref3$visibleRows.endRow,
    visibleRowCount = _ref3$visibleRows.visibleRowCount,
    renderCellValue = _ref3.renderCellValue,
    cellContext = _ref3.cellContext,
    renderCellPopover = _ref3.renderCellPopover,
    renderFooterCellValue = _ref3.renderFooterCellValue,
    interactiveCellId = _ref3.interactiveCellId,
    pagination = _ref3.pagination,
    sorting = _ref3.sorting,
    setVisibleColumns = _ref3.setVisibleColumns,
    switchColumnPos = _ref3.switchColumnPos,
    onColumnResize = _ref3.onColumnResize,
    rowHeightsOptions = _ref3.rowHeightsOptions,
    virtualizationOptions = _ref3.virtualizationOptions,
    isFullScreen = _ref3.isFullScreen,
    gridStyles = _ref3.gridStyles,
    gridWidth = _ref3.gridWidth,
    gridRef = _ref3.gridRef,
    gridItemsRendered = _ref3.gridItemsRendered,
    wrapperRef = _ref3.wrapperRef,
    className = _ref3.className,
    canDragAndDropColumns = _ref3.canDragAndDropColumns;
  /**
   * Grid refs & observers
   */
  var wrapperDimensions = useResizeObserver(wrapperRef.current);
  var outerGridRef = useRef(null); // container that becomes scrollable
  var innerGridRef = useRef(null); // container sized to fit all content

  /**
   * Scroll bars
   */
  var _useScrollBars = useScrollBars(outerGridRef, gridStyles.border),
    scrollBarHeight = _useScrollBars.scrollBarHeight,
    hasVerticalScroll = _useScrollBars.hasVerticalScroll,
    hasHorizontalScroll = _useScrollBars.hasHorizontalScroll,
    scrollBorderOverlay = _useScrollBars.scrollBorderOverlay;

  /**
   * Widths
   */
  var virtualizeContainerWidth = useVirtualizeContainerWidth(outerGridRef.current, gridWidth, pagination === null || pagination === void 0 ? void 0 : pagination.pageSize);

  // compute the default column width from the container's width and count of visible columns
  var defaultColumnWidth = useDefaultColumnWidth(virtualizeContainerWidth, leadingControlColumns, trailingControlColumns, columns);
  var _useColumnWidths = useColumnWidths({
      columns: columns,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      defaultColumnWidth: defaultColumnWidth,
      onColumnResize: onColumnResize
    }),
    columnWidths = _useColumnWidths.columnWidths,
    setColumnWidth = _useColumnWidths.setColumnWidth,
    getColumnWidth = _useColumnWidths.getColumnWidth;

  /**
   * Header & footer
   */
  var _useDataGridHeader = useDataGridHeader({
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      visibleColCount: visibleColCount,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      gridStyles: gridStyles,
      canDragAndDropColumns: canDragAndDropColumns
    }),
    headerRow = _useDataGridHeader.headerRow,
    headerRowHeight = _useDataGridHeader.headerRowHeight;
  var _useDataGridFooter = useDataGridFooter({
      renderFooterCellValue: renderFooterCellValue,
      renderCellPopover: renderCellPopover,
      rowIndex: visibleRowCount,
      visibleRowIndex: visibleRowCount,
      visibleColCount: visibleColCount,
      interactiveCellId: interactiveCellId,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      schema: schema,
      gridStyles: gridStyles
    }),
    footerRow = _useDataGridFooter.footerRow,
    footerRowHeight = _useDataGridFooter.footerRowHeight;

  /**
   * Handle scrolling cells fully into view
   */
  useScroll({
    gridRef: gridRef,
    outerGridRef: outerGridRef,
    hasGridScrolling: hasVerticalScroll || hasHorizontalScroll,
    headerRowHeight: headerRowHeight,
    footerRowHeight: footerRowHeight,
    visibleRowCount: visibleRowCount,
    hasStickyFooter: !!(renderFooterCellValue && gridStyles.stickyFooter),
    canDragAndDropColumns: canDragAndDropColumns
  });

  /**
   * Row manager
   */
  var rowManager = useRowManager({
    innerGridRef: innerGridRef,
    rowClasses: gridStyles.rowClasses
  });

  /**
   * Heights
   */
  var rowHeightUtils = useRowHeightUtils({
    virtualization: {
      gridRef: gridRef,
      outerGridElementRef: outerGridRef,
      gridItemsRenderedRef: gridItemsRendered
    },
    rowHeightsOptions: rowHeightsOptions,
    columns: columns
  });
  var _useDefaultRowHeight = useDefaultRowHeight({
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils
    }),
    defaultRowHeight = _useDefaultRowHeight.defaultRowHeight,
    setRowHeight = _useDefaultRowHeight.setRowHeight,
    getRowHeight = _useDefaultRowHeight.getRowHeight;
  var unconstrainedHeight = useUnconstrainedHeight({
    rowHeightUtils: rowHeightUtils,
    startRow: startRow,
    endRow: endRow,
    rowHeightsOptions: rowHeightsOptions,
    defaultRowHeight: defaultRowHeight,
    headerRowHeight: headerRowHeight,
    footerRowHeight: footerRowHeight,
    scrollBarHeight: scrollBarHeight,
    innerGridRef: innerGridRef
  });

  /**
   * Final grid height & width
   */
  var _useFinalGridDimensio = useFinalGridDimensions({
      unconstrainedHeight: unconstrainedHeight,
      unconstrainedWidth: 0,
      // unable to determine this until the container's size is known
      wrapperDimensions: wrapperDimensions,
      wrapperRef: wrapperRef,
      isFullScreen: isFullScreen,
      rowCount: rowCount
    }),
    finalWidth = _useFinalGridDimensio.finalWidth,
    finalHeight = _useFinalGridDimensio.finalHeight;

  /**
   * Grid resets
   */
  useEffect(function () {
    if (gridRef.current) {
      gridRef.current.resetAfterColumnIndex(0);
    }
  }, [gridRef, columns, columnWidths, defaultColumnWidth]);
  useEffect(function () {
    if (gridRef.current && rowHeightsOptions) {
      gridRef.current.resetAfterRowIndex(0);
    }
  }, [gridRef, pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex, rowHeightsOptions, gridStyles === null || gridStyles === void 0 ? void 0 : gridStyles.cellPadding, gridStyles === null || gridStyles === void 0 ? void 0 : gridStyles.fontSize]);
  useEffect(function () {
    if (gridRef.current) {
      gridRef.current.resetAfterRowIndex(0);
    }
  }, [gridRef, getRowHeight]);
  var onItemsRendered = useCallback(function (itemsRendered) {
    var _virtualizationOption;
    gridItemsRendered.current = itemsRendered;
    virtualizationOptions === null || virtualizationOptions === void 0 || (_virtualizationOption = virtualizationOptions.onItemsRendered) === null || _virtualizationOption === void 0 || _virtualizationOption.call(virtualizationOptions, itemsRendered);
  }, [gridItemsRendered, virtualizationOptions]);
  var itemData = useMemo(function () {
    return {
      schemaDetectors: schemaDetectors,
      setRowHeight: setRowHeight,
      leadingControlColumns: leadingControlColumns,
      trailingControlColumns: trailingControlColumns,
      columns: columns,
      visibleColCount: visibleColCount,
      schema: schema,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      renderCellValue: renderCellValue,
      cellContext: cellContext,
      renderCellPopover: renderCellPopover,
      interactiveCellId: interactiveCellId,
      rowHeightsOptions: rowHeightsOptions,
      rowHeightUtils: rowHeightUtils,
      rowManager: rowManager,
      pagination: pagination,
      headerRowHeight: headerRowHeight,
      gridStyles: gridStyles
    };
  }, [schemaDetectors, setRowHeight, leadingControlColumns, trailingControlColumns, columns, visibleColCount, schema, columnWidths, defaultColumnWidth, renderCellValue, cellContext, renderCellPopover, interactiveCellId, rowHeightsOptions, rowHeightUtils, rowManager, pagination, headerRowHeight, gridStyles]);
  var rowWrapperContextValue = useMemo(function () {
    return {
      headerRowHeight: headerRowHeight,
      headerRow: headerRow,
      footerRow: footerRow
    };
  }, [headerRowHeight, headerRow, footerRow]);
  return IS_JEST_ENVIRONMENT || finalWidth > 0 ? ___EmotionJSX(DataGridWrapperRowsContext.Provider, {
    value: rowWrapperContextValue
  }, ___EmotionJSX(Grid, _extends({}, virtualizationOptions, {
    ref: gridRef,
    className: classNames('euiDataGrid__virtualized', className, virtualizationOptions === null || virtualizationOptions === void 0 ? void 0 : virtualizationOptions.className),
    onItemsRendered: onItemsRendered,
    innerElementType: InnerElement,
    outerRef: outerGridRef,
    innerRef: innerGridRef,
    columnCount: visibleColCount,
    width: finalWidth,
    columnWidth: getColumnWidth,
    height: finalHeight,
    rowHeight: getRowHeight,
    itemData: itemData,
    rowCount: IS_JEST_ENVIRONMENT || headerRowHeight > 0 ? visibleRowCount : 0
  }), Cell), scrollBorderOverlay) : null;
});
EuiDataGridBodyVirtualized.displayName = 'EuiDataGridBodyVirtualized';