import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["renderFooterCellValue"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo } from 'react';
import { useResizeObserver } from '../../../observer/resize_observer';
import { EuiDataGridFooterRow } from './data_grid_footer_row';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * DRY out setting up the grid footer and its refs & observers
 */
export var useDataGridFooter = function useDataGridFooter(props) {
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    footerRowRef = _useState2[0],
    setFooterRowRef = _useState2[1];
  var _useResizeObserver = useResizeObserver(footerRowRef, 'height'),
    footerRowHeight = _useResizeObserver.height;
  var footerRow = useMemo(function () {
    var renderFooterCellValue = props.renderFooterCellValue,
      footerProps = _objectWithoutProperties(props, _excluded);
    if (renderFooterCellValue == null) return null;
    return ___EmotionJSX(EuiDataGridFooterRow, _extends({
      ref: setFooterRowRef,
      renderCellValue: renderFooterCellValue
    }, footerProps));
  }, [props]);
  return {
    footerRow: footerRow,
    footerRowHeight: footerRowHeight
  };
};