import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { RenderWithEuiStylesMemoizer } from '../../../../services';
import { logicalStyle } from '../../../../global_styling';
import { DragOverlay } from './draggable_columns';
import { euiDataGridColumnResizerStyles } from './column_resizer.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var MINIMUM_COLUMN_WIDTH = 40;
export var EuiDataGridColumnResizer = /*#__PURE__*/function (_Component) {
  function EuiDataGridColumnResizer() {
    var _this;
    _classCallCheck(this, EuiDataGridColumnResizer);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDataGridColumnResizer, [].concat(args));
    _defineProperty(_this, "state", {
      initialX: 0,
      offset: 0
    });
    _defineProperty(_this, "onMouseDown", function (e) {
      _this.setState({
        initialX: e.pageX
      });
      window.addEventListener('mouseup', _this.onMouseUp);
      window.addEventListener('blur', _this.onMouseUp);
      window.addEventListener('mousemove', _this.onMouseMove);

      // don't let this action steal focus
      e.preventDefault();
    });
    _defineProperty(_this, "onMouseUp", function () {
      var offset = _this.state.offset;
      var _this$props = _this.props,
        columnId = _this$props.columnId,
        columnWidth = _this$props.columnWidth,
        setColumnWidth = _this$props.setColumnWidth;
      setColumnWidth(columnId, Math.max(MINIMUM_COLUMN_WIDTH, columnWidth + offset));
      _this.setState({
        offset: 0
      });
      window.removeEventListener('mouseup', _this.onMouseUp);
      window.removeEventListener('blur', _this.onMouseUp);
      window.removeEventListener('mousemove', _this.onMouseMove);
    });
    _defineProperty(_this, "onMouseMove", function (e) {
      var columnWidth = _this.props.columnWidth;
      _this.setState(function (_ref) {
        var initialX = _ref.initialX;
        return {
          offset: Math.max(e.pageX - initialX, -(columnWidth - MINIMUM_COLUMN_WIDTH))
        };
      });
    });
    return _this;
  }
  _inherits(EuiDataGridColumnResizer, _Component);
  return _createClass(EuiDataGridColumnResizer, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var offset = this.state.offset;
      var isLastColumn = this.props.isLastColumn;
      return ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(euiDataGridColumnResizerStyles);
        var cssStyles = [styles.euiDataGridColumnResizer, isLastColumn && styles.isLastColumn, offset && styles.isDragging];
        return ___EmotionJSX("div", {
          css: cssStyles,
          className: "euiDataGridColumnResizer",
          "data-test-subj": "dataGridColumnResizer",
          style: offset ? logicalStyle('margin-right', "".concat(-offset, "px")) : undefined,
          onMouseDown: _this2.onMouseDown
        }, ___EmotionJSX(DragOverlay, {
          isDragging: !!offset,
          cursor: "ew-resize"
        }));
      });
    }
  }]);
}(Component);