import _extends from "@babel/runtime/helpers/extends";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo } from 'react';
import classNames from 'classnames';
import { EuiDataGridHeaderCellWrapper } from './data_grid_header_cell_wrapper';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridControlHeaderCell = /*#__PURE__*/memo(function (_ref) {
  var controlColumn = _ref.controlColumn,
    index = _ref.index,
    isLastColumn = _ref.isLastColumn;
  var HeaderCellRender = controlColumn.headerCellRender,
    headerCellProps = controlColumn.headerCellProps,
    width = controlColumn.width,
    id = controlColumn.id;
  return ___EmotionJSX(EuiDataGridHeaderCellWrapper, _extends({}, headerCellProps, {
    className: classNames('euiDataGridHeaderCell--controlColumn', headerCellProps === null || headerCellProps === void 0 ? void 0 : headerCellProps.className),
    id: id,
    index: index,
    width: width,
    isLastColumn: isLastColumn
  }), ___EmotionJSX(HeaderCellRender, null));
});
EuiDataGridControlHeaderCell.displayName = 'EuiDataGridControlHeaderCell';