import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classnames from 'classnames';
import React, { memo, useMemo, useRef, useState } from 'react';
import { useEuiMemoizedStyles } from '../../../../services';
import { EuiIcon } from '../../../icon';
import { useHasColumnActions, ColumnActions } from './column_actions';
import { useColumnSorting } from './column_sorting';
import { ConditionalDraggableColumn } from './draggable_columns';
import { EuiDataGridColumnResizer } from './column_resizer';
import { EuiDataGridHeaderCellWrapper } from './data_grid_header_cell_wrapper';
import { euiDataGridHeaderCellStyles } from './data_grid_header_cell.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridHeaderCell = /*#__PURE__*/memo(function (_ref) {
  var index = _ref.index,
    column = _ref.column,
    columns = _ref.columns,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    setColumnWidth = _ref.setColumnWidth,
    setVisibleColumns = _ref.setVisibleColumns,
    switchColumnPos = _ref.switchColumnPos,
    isLastColumn = _ref.isLastColumn,
    sorting = _ref.sorting,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    canDragAndDropColumns = _ref.canDragAndDropColumns,
    gridStyles = _ref.gridStyles;
  var id = column.id,
    display = column.display,
    displayAsText = column.displayAsText,
    displayHeaderCellProps = column.displayHeaderCellProps,
    actions = column.actions;
  var title = displayAsText || id;
  var children = display || displayAsText || id;
  var width = columnWidths[id] || defaultColumnWidth;
  var columnType = schema[id] ? schema[id].columnType : null;
  var hasColumnActions = useHasColumnActions(actions);
  var classes = classnames(_defineProperty(_defineProperty({}, "euiDataGridHeaderCell--".concat(columnType), columnType), 'euiDataGridHeaderCell--hasColumnActions', hasColumnActions), displayHeaderCellProps === null || displayHeaderCellProps === void 0 ? void 0 : displayHeaderCellProps.className);
  var styles = useEuiMemoizedStyles(euiDataGridHeaderCellStyles);
  var contentStyles = [styles.euiDataGridHeaderCell__content, (columnType === 'numeric' || columnType === 'currency') && styles.right];

  // Props passed from <ColumnActions /> to be set on <EuiDataGridHeaderCellWrapper />
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    propsFromColumnActions = _useState2[0],
    setPropsFromColumnActions = _useState2[1];
  var actionsButtonRef = useRef(null);
  var _useColumnSorting = useColumnSorting({
      sorting: sorting,
      id: id,
      hasColumnActions: hasColumnActions
    }),
    sortingArrow = _useColumnSorting.sortingArrow,
    ariaSort = _useColumnSorting.ariaSort,
    sortingAriaId = _useColumnSorting.sortingAriaId,
    sortingScreenReaderText = _useColumnSorting.sortingScreenReaderText;
  var columnResizer = useMemo(function () {
    return column.isResizable !== false && width != null ? ___EmotionJSX(EuiDataGridColumnResizer, {
      columnId: id,
      columnWidth: width,
      setColumnWidth: setColumnWidth,
      isLastColumn: isLastColumn
    }) : null;
  }, [column.isResizable, id, width, setColumnWidth, isLastColumn]);
  return ___EmotionJSX(ConditionalDraggableColumn, {
    id: id,
    index: index,
    canDragAndDropColumns: !!canDragAndDropColumns,
    gridStyles: gridStyles,
    columnResizer: columnResizer,
    actionsPopoverToggle: actionsButtonRef.current
  }, function (dragProps) {
    return ___EmotionJSX(EuiDataGridHeaderCellWrapper, _extends({}, displayHeaderCellProps, dragProps, {
      hasColumnActions: hasColumnActions
    }, propsFromColumnActions, {
      className: classnames(classes, propsFromColumnActions.className),
      id: id,
      index: index,
      isLastColumn: isLastColumn,
      width: width,
      "aria-sort": ariaSort,
      "aria-label": displayAsText && "".concat(displayAsText, ", ") // ensure cell text content is read first, if available
      ,
      "aria-describedby": classnames(sortingAriaId, dragProps === null || dragProps === void 0 ? void 0 : dragProps['aria-describedby']),
      "data-column-moving": propsFromColumnActions['data-column-moving'] || (dragProps === null || dragProps === void 0 ? void 0 : dragProps['data-column-moving']) || undefined
    }), function (hasFocusTrap) {
      return ___EmotionJSX(React.Fragment, null, !canDragAndDropColumns && columnResizer, canDragAndDropColumns && ___EmotionJSX("span", {
        className: "euiDataGridHeaderCell__draggableIcon"
      }, ___EmotionJSX(EuiIcon, {
        type: "grabOmnidirectional",
        size: "s",
        css: styles.euiDataGridHeaderCell__actions
      })), ___EmotionJSX("div", {
        css: contentStyles,
        className: "euiDataGridHeaderCell__content",
        title: title
      }, children), sortingArrow, sortingScreenReaderText, hasColumnActions && ___EmotionJSX(ColumnActions, {
        index: index,
        id: id,
        title: title,
        column: column,
        columns: columns,
        schema: schema,
        schemaDetectors: schemaDetectors,
        setVisibleColumns: setVisibleColumns,
        switchColumnPos: switchColumnPos,
        sorting: sorting,
        hasFocusTrap: hasFocusTrap,
        setPropsFromColumnActions: setPropsFromColumnActions,
        actionsButtonRef: actionsButtonRef
      }));
    });
  });
});
EuiDataGridHeaderCell.displayName = 'EuiDataGridHeaderCell';