/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiCanAnimate, euiTextTruncate, logicalCSS, logicalTextAlignCSS } from '../../../../global_styling';
import { euiDataGridCellOutlineSelectors } from '../cell/data_grid_cell.styles';

/**
 * Styles only applied to data header cell content, not control header cells
 */
export var euiDataGridHeaderCellStyles = function euiDataGridHeaderCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridCellOutli = euiDataGridCellOutlineSelectors('.euiDataGridHeaderCell'),
    header = _euiDataGridCellOutli.header;
  return {
    euiDataGridHeaderCell__content: /*#__PURE__*/css("flex-grow:1;", euiTextTruncate(), ";;label:euiDataGridHeaderCell__content;"),
    // Numeric and currency schemas are aligned to the right
    right: /*#__PURE__*/css(logicalTextAlignCSS('right'), ";;label:right;"),
    euiDataGridHeaderCell__popover: /*#__PURE__*/css(logicalCSS('margin-left', 'auto'), "line-height:0;;label:euiDataGridHeaderCell__popover;"),
    euiDataGridHeaderCell__actions: /*#__PURE__*/css("overflow:hidden;display:flex;", header.hideActions, " &{", logicalCSS('width', 0), " opacity:0;}", euiCanAnimate, "{transition:inline-size ", euiTheme.animation.fast, " ease-in,opacity ", euiTheme.animation.slow, " ease-in;transform:none!important;animation:none!important;};label:euiDataGridHeaderCell__actions;")
  };
};