import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "index", "isLastColumn", "width", "className", "children", "hasColumnActions", "isDragging", "onKeyDown", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useEffect, useState, useCallback } from 'react';
import classnames from 'classnames';
import { keys, tabularCopyMarkers, useEuiMemoizedStyles } from '../../../../services';
import { DataGridFocusContext } from '../../utils/focus';
import { HandleInteractiveChildren } from '../cell/focus_utils';
import { euiDataGridHeaderCellWrapperStyles } from './data_grid_header_cell_wrapper.styles';

/**
 * This is a wrapper that handles repeated concerns between control &
 * standard header cells. Most of its shared logic is around focus state/UX,
 * but it also DRY's out certain class/data-test-subj/style attributes
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridHeaderCellWrapper = function EuiDataGridHeaderCellWrapper(_ref) {
  var id = _ref.id,
    index = _ref.index,
    isLastColumn = _ref.isLastColumn,
    width = _ref.width,
    className = _ref.className,
    children = _ref.children,
    hasColumnActions = _ref.hasColumnActions,
    isDragging = _ref.isDragging,
    _onKeyDown = _ref.onKeyDown,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiDataGridHeaderCell', className);
  var styles = useEuiMemoizedStyles(euiDataGridHeaderCellWrapperStyles);

  // Must be a state and not a ref to trigger a HandleInteractiveChildren rerender
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    headerEl = _useState2[0],
    setHeaderEl = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    renderFocusTrap = _useState4[0],
    setRenderFocusTrap = _useState4[1];
  var _useState5 = useState([]),
    _useState6 = _slicedToArray(_useState5, 2),
    interactiveChildren = _useState6[0],
    setInteractiveChildren = _useState6[1];
  useEffect(function () {
    // We're checking for interactive children outside of the default actions button
    setRenderFocusTrap(interactiveChildren.length > (hasColumnActions ? 1 : 0));
  }, [hasColumnActions, interactiveChildren]);
  var _useContext = useContext(DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell,
    onFocusUpdate = _useContext.onFocusUpdate;
  var updateCellFocusContext = useCallback(function () {
    setFocusedCell([index, -1]);
  }, [index, setFocusedCell]);
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isFocused = _useState8[0],
    setIsFocused = _useState8[1];
  useEffect(function () {
    onFocusUpdate([index, -1], function (isFocused) {
      setIsFocused(isFocused);
      if (isFocused && headerEl) {
        // Only focus the cell if not already focused on something in the cell
        if (!headerEl.contains(document.activeElement)) {
          headerEl.focus();
        }
      }
    });
  }, [index, onFocusUpdate, headerEl]);
  var onKeyDown = useCallback(function (e) {
    // Ignore keys that conflict with the focus trap being entered/exited
    if (renderFocusTrap && (e.key === keys.ENTER || e.key === keys.ESCAPE)) {
      return;
    }
    // Otherwise, continue with whatever onKeyDown is being passed
    _onKeyDown === null || _onKeyDown === void 0 || _onKeyDown(e);
  }, [_onKeyDown, renderFocusTrap]);
  return ___EmotionJSX("div", _extends({
    role: "columnheader",
    ref: setHeaderEl,
    tabIndex: isFocused ? 0 : -1,
    onKeyDown: onKeyDown,
    css: styles.euiDataGridHeaderCell,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    "data-gridcell-column-id": id,
    "data-gridcell-column-index": index,
    "data-gridcell-row-index": "-1",
    "data-gridcell-visible-row-index": "-1",
    style: width != null ? {
      width: "".concat(width, "px")
    } : {},
    "aria-label": renderFocusTrap ? ariaLabel : undefined
  }, rest), ___EmotionJSX(HandleInteractiveChildren, {
    cellEl: isDragging ? null : headerEl,
    renderFocusTrap: isDragging ? false : renderFocusTrap,
    updateCellFocusContext: updateCellFocusContext,
    onInteractiveChildrenFound: setInteractiveChildren
  }, typeof children === 'function' ? children(renderFocusTrap) : children), isLastColumn ? tabularCopyMarkers.hiddenNewline : tabularCopyMarkers.hiddenTab);
};