import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "data-test-subj", "leadingControlColumns", "trailingControlColumns", "columns", "columnWidths", "defaultColumnWidth", "setColumnWidth", "visibleColCount", "setVisibleColumns", "switchColumnPos", "sorting", "schema", "schemaDetectors", "gridStyles", "canDragAndDropColumns"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classnames from 'classnames';
import React, { forwardRef, memo, useCallback } from 'react';
import { useEuiMemoizedStyles } from '../../../../services';
import { emptyControlColumns } from '../../data_grid_types';
import { ConditionalDroppableColumns } from './draggable_columns';
import { EuiDataGridControlHeaderCell } from './data_grid_control_header_cell';
import { EuiDataGridHeaderCell } from './data_grid_header_cell';
import { euiDataGridHeaderStyles } from './data_grid_header_row.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var EuiDataGridHeaderRow = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (props, ref) {
  var _leadingControlColumn;
  var className = props.className,
    _dataTestSubj = props['data-test-subj'],
    _props$leadingControl = props.leadingControlColumns,
    leadingControlColumns = _props$leadingControl === void 0 ? emptyControlColumns : _props$leadingControl,
    _props$trailingContro = props.trailingControlColumns,
    trailingControlColumns = _props$trailingContro === void 0 ? emptyControlColumns : _props$trailingContro,
    columns = props.columns,
    columnWidths = props.columnWidths,
    defaultColumnWidth = props.defaultColumnWidth,
    setColumnWidth = props.setColumnWidth,
    visibleColCount = props.visibleColCount,
    setVisibleColumns = props.setVisibleColumns,
    switchColumnPos = props.switchColumnPos,
    sorting = props.sorting,
    schema = props.schema,
    schemaDetectors = props.schemaDetectors,
    gridStyles = props.gridStyles,
    canDragAndDropColumns = props.canDragAndDropColumns,
    rest = _objectWithoutProperties(props, _excluded);
  var styles = useEuiMemoizedStyles(euiDataGridHeaderStyles);
  var cssStyles = [styles.euiDataGridHeader, styles[gridStyles.header]];
  var classes = classnames('euiDataGridHeader', className);
  var dataTestSubj = classnames('dataGridHeader', _dataTestSubj);
  var isLastColumn = useCallback(function (index) {
    return index === visibleColCount - 1;
  }, [visibleColCount]);
  return ___EmotionJSX("div", _extends({
    role: "row",
    ref: ref,
    css: cssStyles,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (controlColumn, index) {
    return ___EmotionJSX(EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: index,
      isLastColumn: isLastColumn(index),
      controlColumn: controlColumn
    });
  }), ___EmotionJSX(ConditionalDroppableColumns, {
    canDragAndDropColumns: !!canDragAndDropColumns,
    columns: columns,
    switchColumnPos: switchColumnPos,
    indexOffset: (_leadingControlColumn = leadingControlColumns === null || leadingControlColumns === void 0 ? void 0 : leadingControlColumns.length) !== null && _leadingControlColumn !== void 0 ? _leadingControlColumn : 0
  }, columns.map(function (column, index) {
    var visibleIndex = index + leadingControlColumns.length;
    return ___EmotionJSX(EuiDataGridHeaderCell, {
      key: column.id,
      index: visibleIndex,
      isLastColumn: isLastColumn(visibleIndex),
      column: column,
      columns: columns,
      columnWidths: columnWidths,
      defaultColumnWidth: defaultColumnWidth,
      setColumnWidth: setColumnWidth,
      setVisibleColumns: setVisibleColumns,
      switchColumnPos: switchColumnPos,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors,
      canDragAndDropColumns: canDragAndDropColumns,
      gridStyles: gridStyles
    });
  })), trailingControlColumns.map(function (controlColumn, index) {
    var visibleIndex = index + leadingControlColumns.length + columns.length;
    return ___EmotionJSX(EuiDataGridControlHeaderCell, {
      key: controlColumn.id,
      index: visibleIndex,
      isLastColumn: isLastColumn(visibleIndex),
      controlColumn: controlColumn
    });
  }));
}));
EuiDataGridHeaderRow.displayName = 'EuiDataGridHeaderRow';
export { EuiDataGridHeaderRow };