import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
var _excluded = ["role", "tabIndex"],
  _excluded2 = ["canDragAndDropColumns", "children"],
  _excluded3 = ["canDragAndDropColumns", "children"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo, useCallback, useContext, useRef } from 'react';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../../../services';
import { EuiDragDropContext, EuiDroppable, EuiDraggable } from '../../../drag_and_drop';
import { EuiPortal } from '../../../portal';
import { DataGridFocusContext } from '../../utils/focus';
import { euiDataGridStyles } from '../../data_grid.styles';
import { euiDataGridDraggableHeaderStyles } from './draggable_columns.styles';

/**
 * Parent context + EuiDroppable wrapper
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var DroppableColumns = /*#__PURE__*/memo(function (_ref) {
  var columns = _ref.columns,
    switchColumnPos = _ref.switchColumnPos,
    indexOffset = _ref.indexOffset,
    children = _ref.children;
  var styles = useEuiMemoizedStyles(euiDataGridDraggableHeaderStyles);
  var droppableId = useGeneratedHtmlId({
    prefix: 'euiDataGridHeaderDroppable'
  });
  var _useContext = useContext(DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell;
  var handleOnDragEnd = useCallback(function (_ref2) {
    var source = _ref2.source,
      destination = _ref2.destination;
    if (!source) return;
    if (destination && destination.index !== source.index) {
      var sourceColumn = columns[source.index - indexOffset];
      var destinationColumn = columns[destination.index - indexOffset];
      if (sourceColumn && destinationColumn) {
        switchColumnPos(sourceColumn.id, destinationColumn.id);
      }
    }
    // Force focus the cell to prevent the datagrid body from become unfocusable, including on drag cancel
    setTimeout(function () {
      var cellToFocus = destination ? destination.index : source.index;
      setFocusedCell([cellToFocus, -1], true);
    });
  }, [columns, indexOffset, switchColumnPos, setFocusedCell]);
  return ___EmotionJSX(EuiDragDropContext, {
    onDragEnd: handleOnDragEnd
  }, ___EmotionJSX(EuiDroppable, {
    droppableId: droppableId,
    direction: "horizontal",
    ignoreContainerClipping: true,
    css: styles.euiDataGridHeaderDroppable,
    "data-test-subj": "euiDataGridHeaderDroppable"
  }, children));
});
DroppableColumns.displayName = 'DroppableColumns';

/**
 * Individual EuiDraggable columns
 */
export var DraggableColumn = /*#__PURE__*/memo(function (_ref3) {
  var id = _ref3.id,
    index = _ref3.index,
    gridStyles = _ref3.gridStyles,
    columnResizer = _ref3.columnResizer,
    actionsPopoverToggle = _ref3.actionsPopoverToggle,
    children = _ref3.children;
  var dataGridStyles = useEuiMemoizedStyles(euiDataGridStyles);
  var styles = useEuiMemoizedStyles(euiDataGridDraggableHeaderStyles);
  // Manually re-apply background and border overrides, since
  // the droppable zone sets its own and confuses :first-of-type CSS
  var reapplyCellStyles = [styles[gridStyles.header], index !== 0 && styles.noLeadingBorder];

  // Draggable prevents the cell from receiving focus on click.
  // We manually ensure focus is set on cell mouseDown which
  // also includes setting focus before dragging
  var _useContext2 = useContext(DataGridFocusContext),
    setFocusedCell = _useContext2.setFocusedCell;
  var handleOnMouseDown = useCallback(function (e) {
    var openFocusTraps = document.querySelectorAll('[data-focus-lock-disabled="false"]');
    var validOpenFocusTraps = _toConsumableArray(openFocusTraps).filter(function (focusTrap) {
      return !focusTrap.contains(e.currentTarget);
    } // remove containing focus traps (e.g. modals or flyouts)
    );
    var shouldDispatchEvent = validOpenFocusTraps.some(function (focusTrap) {
      return !!focusTrap &&
      // If there is a focus trap open
      !focusTrap.contains(e.target) &&
      // & if it doesn't contain the target
      e.target !== actionsPopoverToggle;
    } // & we're not closing the actions popover toggle
    );
    if (shouldDispatchEvent) {
      // Trick the focus trap lib into registering an outside click -
      // the drag/drop lib otherwise prevents the event 💀
      document.dispatchEvent(new MouseEvent('mousedown'));
    }
    setTimeout(function () {
      setFocusedCell([index, -1], true);
    });
  }, [setFocusedCell, index, actionsPopoverToggle]);

  // Prevent any other keypresses when dragging
  var isDraggingRef = useRef(false);
  var handleOnKeydown = useCallback(function (e) {
    if (isDraggingRef.current) {
      e.preventDefault();
      e.stopPropagation();
      return false;
    }
  }, []);

  // UX polish: add a slight animation frame delay to the dragging ref end
  // which prevents re-running the hover animation of column header actions
  var updateDraggingRef = useCallback(function (isDragging) {
    // Only update if the state has changed from before
    if (isDragging !== isDraggingRef.current) {
      if (!isDragging) {
        requestAnimationFrame(function () {
          isDraggingRef.current = false;
        });
      } else {
        isDraggingRef.current = true;
      }
    }
  }, []);
  return ___EmotionJSX("div", {
    css: styles.euiDataGridHeaderCellDraggableWrapper,
    onMouseDown: handleOnMouseDown,
    onKeyDownCapture: handleOnKeydown
  }, columnResizer, ___EmotionJSX(EuiDraggable, {
    draggableId: id,
    className: "euiDataGridHeaderCellDraggable",
    css: styles.euiDataGridHeaderCellDraggable,
    index: index,
    customDragHandle: "custom",
    hasInteractiveChildren: true,
    usePortal: true
  }, function (_ref4, _ref5) {
    var dragHandleProps = _ref4.dragHandleProps;
    var isDragging = _ref5.isDragging,
      mode = _ref5.mode;
    updateDraggingRef(isDragging);
    var _ref6 = dragHandleProps !== null && dragHandleProps !== void 0 ? dragHandleProps : {},
      role = _ref6.role,
      tabIndex = _ref6.tabIndex,
      restDragHandleProps = _objectWithoutProperties(_ref6, _excluded);
    var passedProps = _objectSpread(_objectSpread({}, restDragHandleProps), {}, {
      css: reapplyCellStyles,
      'data-column-moving': isDraggingRef.current || undefined,
      isDragging: isDragging
    });

    // since the cloned content is in a portal outside the datagrid
    // we need to re-add styles to the cell as the scoped styles
    // from the wrapper don't apply
    var draggingStyles = [styles.euiDataGridHeaderCellDraggable,
    // ensure height is maintained while dragging
    dataGridStyles.cellPadding[gridStyles.cellPadding], dataGridStyles.fontSize[gridStyles.fontSize], dataGridStyles.borders[gridStyles.border], mode === 'SNAP' && styles.isKeyboardDragging];
    return isDragging ? ___EmotionJSX("div", {
      css: draggingStyles
    }, ___EmotionJSX(DragOverlay, {
      isDragging: true,
      cursor: "grabbing"
    }), children(passedProps)) : children(passedProps);
  }));
});
DraggableColumn.displayName = 'DraggableColumn';

/**
 * Components for conditionally rendering drag/drop wrappers
 * Allows us to conditionally call hooks while not instantiating a bunch
 * of extra state/etc., since draggable columns isn't yet(?) a default
 */

export var ConditionalDroppableColumns = /*#__PURE__*/memo(function (_ref7) {
  var canDragAndDropColumns = _ref7.canDragAndDropColumns,
    children = _ref7.children,
    rest = _objectWithoutProperties(_ref7, _excluded2);
  return canDragAndDropColumns ? ___EmotionJSX(DroppableColumns, rest, children) : ___EmotionJSX(React.Fragment, null, children);
});
ConditionalDroppableColumns.displayName = 'ConditionalDroppableColumns';
export var ConditionalDraggableColumn = /*#__PURE__*/memo(function (_ref8) {
  var canDragAndDropColumns = _ref8.canDragAndDropColumns,
    children = _ref8.children,
    rest = _objectWithoutProperties(_ref8, _excluded3);
  return canDragAndDropColumns ? ___EmotionJSX(DraggableColumn, rest, children) : ___EmotionJSX(React.Fragment, null, children());
});
ConditionalDraggableColumn.displayName = 'ConditionalDraggableColumn';

/**
 * Creates an invisible overlay that prevents hover interactions/transitions
 * on other elements that the dragged element is dragged over, and also maintains
 * the intended drag cursor over any location.
 *
 * TODO: If this is useful elsewhere, consider moving it to `src/services`
 */
var _ref10 = process.env.NODE_ENV === "production" ? {
  name: "q8wbl-DragOverlay",
  styles: "position:fixed;inset:0;label:DragOverlay;"
} : {
  name: "q8wbl-DragOverlay",
  styles: "position:fixed;inset:0;label:DragOverlay;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var DragOverlay = /*#__PURE__*/memo(function (_ref9) {
  var isDragging = _ref9.isDragging,
    cursor = _ref9.cursor,
    _ref9$zIndex = _ref9.zIndex,
    zIndex = _ref9$zIndex === void 0 ? 9999 : _ref9$zIndex;
  return isDragging ? ___EmotionJSX(EuiPortal, null, ___EmotionJSX("div", {
    css: _ref10,
    style: {
      cursor: cursor,
      zIndex: zIndex
    }
  })) : null;
});
DragOverlay.displayName = 'DragOverlay';