import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo } from 'react';
import { useResizeObserver } from '../../../observer/resize_observer';
import { EuiDataGridHeaderRow } from './data_grid_header_row';

/**
 * DRY out setting up the grid header and its refs & observers
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useDataGridHeader = function useDataGridHeader(props) {
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    headerRowRef = _useState2[0],
    setHeaderRowRef = _useState2[1];
  var _useResizeObserver = useResizeObserver(headerRowRef, 'height'),
    headerRowHeight = _useResizeObserver.height;
  var headerRow = useMemo(function () {
    return ___EmotionJSX(EuiDataGridHeaderRow, _extends({
      ref: setHeaderRowRef
    }, props));
  }, [props]);
  return useMemo(function () {
    return {
      headerRow: headerRow,
      headerRowHeight: headerRowHeight
    };
  }, [headerRow, headerRowHeight]);
};