import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, useCallback } from 'react';
import classNames from 'classnames';
import { useDependentState, useEuiMemoizedStyles } from '../../../services';
import { EuiPopover, EuiPopoverFooter, EuiPopoverTitle } from '../../popover';
import { EuiI18n, useEuiI18n } from '../../i18n';
import { EuiButtonEmpty } from '../../button';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiSwitch, EuiFieldText } from '../../form';
import { EuiText } from '../../text';
import { EuiIcon } from '../../icon';
import { EuiDragDropContext, EuiDraggable, EuiDroppable, euiDragDropReorder } from '../../drag_and_drop';
import { getNestedObjectOptions } from './data_grid_toolbar';
import { EuiDataGridToolbarControl } from './data_grid_toolbar_control';
import { euiDataGridColumnSelectorStyles } from './column_selector.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useDataGridColumnSelector = function useDataGridColumnSelector(availableColumns, columnVisibility, showColumnSelector, displayValues) {
  var allowColumnHiding = getNestedObjectOptions(showColumnSelector, 'allowHide');
  var allowColumnReorder = getNestedObjectOptions(showColumnSelector, 'allowReorder');
  var _useDependentState = useDependentState(function () {
      return availableColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      });
    }, [availableColumns]),
    _useDependentState2 = _slicedToArray(_useDependentState, 2),
    sortedColumns = _useDependentState2[0],
    setSortedColumns = _useDependentState2[1];
  var visibleColumns = columnVisibility.visibleColumns,
    setVisibleColumns = columnVisibility.setVisibleColumns;
  var visibleColumnIds = useMemo(function () {
    return new Set(visibleColumns);
  }, [visibleColumns]);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var setColumns = useCallback(function (nextColumns) {
    setSortedColumns(nextColumns);
    var nextVisibleColumns = nextColumns.filter(function (id) {
      return visibleColumnIds.has(id);
    });
    setVisibleColumns(nextVisibleColumns);
  }, [setSortedColumns, setVisibleColumns, visibleColumnIds]);
  var onDragEnd = useCallback(function (_ref2) {
    var sourceIndex = _ref2.source.index,
      destination = _ref2.destination;
    if (destination) {
      var destinationIndex = destination.index;
      var nextSortedColumns = euiDragDropReorder(sortedColumns, sourceIndex, destinationIndex);
      setColumns(nextSortedColumns);
    }
  }, [sortedColumns, setColumns]);
  var numberOfHiddenFields = availableColumns.length - visibleColumns.length;
  var _useState3 = useState(''),
    _useState4 = _slicedToArray(_useState3, 2),
    columnSearchText = _useState4[0],
    setColumnSearchText = _useState4[1];
  var filteredColumns = useMemo(function () {
    return sortedColumns.filter(function (id) {
      return (displayValues[id] || id).toLowerCase().indexOf(columnSearchText.toLowerCase()) !== -1;
    });
  }, [sortedColumns, columnSearchText, displayValues]);
  var isDragEnabled = allowColumnReorder && columnSearchText.length === 0; // only allow drag-and-drop when not filtering columns
  var dragHandleAriaLabel = useEuiI18n('euiColumnSelector.dragHandleAriaLabel', 'Drag handle');
  var orderedVisibleColumns = useMemo(function () {
    return visibleColumns.map(function (columnId) {
      return availableColumns.find(function (_ref3) {
        var id = _ref3.id;
        return id === columnId;
      });
    } // cast to avoid `undefined`, it filters those out next
    ).filter(function (column) {
      return column != null;
    });
  }, [availableColumns, visibleColumns]);
  var styles = useEuiMemoizedStyles(euiDataGridColumnSelectorStyles);
  var columnSelector = useMemo(function () {
    return allowColumnHiding || allowColumnReorder ? ___EmotionJSX(EuiPopover, {
      "data-test-subj": "dataGridColumnSelectorPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downLeft",
      panelPaddingSize: "none",
      button: ___EmotionJSX(EuiDataGridToolbarControl, {
        badgeContent: numberOfHiddenFields > 0 ? "".concat(orderedVisibleColumns.length, "/").concat(availableColumns.length) : availableColumns.length,
        iconType: "tableDensityNormal",
        "data-test-subj": "dataGridColumnSelectorButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        }
      }, ___EmotionJSX(EuiI18n, {
        token: "euiColumnSelector.button",
        default: "Columns"
      }))
    }, allowColumnHiding && ___EmotionJSX(EuiPopoverTitle, {
      paddingSize: "s"
    }, ___EmotionJSX(EuiI18n, {
      tokens: ['euiColumnSelector.search', 'euiColumnSelector.searchcolumns'],
      defaults: ['Search', 'Search columns']
    }, function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        search = _ref5[0],
        searchcolumns = _ref5[1];
      return ___EmotionJSX(EuiFieldText, {
        compressed: true,
        placeholder: search,
        "aria-label": searchcolumns,
        value: columnSearchText,
        onChange: function onChange(e) {
          return setColumnSearchText(e.currentTarget.value);
        },
        "data-test-subj": "dataGridColumnSelectorSearch"
      });
    })), ___EmotionJSX(EuiDragDropContext, {
      onDragEnd: onDragEnd
    }, ___EmotionJSX(EuiDroppable, {
      droppableId: "columnOrder",
      isDropDisabled: !isDragEnabled,
      css: styles.euiDataGridColumnSelector
    }, ___EmotionJSX(React.Fragment, null, filteredColumns.map(function (id, index) {
      return ___EmotionJSX(EuiDraggable, {
        key: id,
        draggableId: id,
        index: index,
        isDragDisabled: !isDragEnabled,
        hasInteractiveChildren: true,
        customDragHandle: true,
        usePortal: true
      }, function (provided, state) {
        return ___EmotionJSX("div", {
          css: styles.euiDataGridColumnSelector__item,
          className: classNames('euiDataGridColumnSelector__item', {
            'euiDataGridColumnSelector__item-isDragging': state.isDragging
          }),
          "data-test-subj": "dataGridColumnSelectorColumnItem-".concat(id)
        }, ___EmotionJSX(EuiFlexGroup, {
          responsive: false,
          gutterSize: "s",
          alignItems: "center"
        }, allowColumnHiding && ___EmotionJSX(EuiFlexItem, {
          grow: false
        }, ___EmotionJSX(EuiSwitch, {
          name: id,
          label: displayValues[id] || id,
          showLabel: false,
          checked: visibleColumnIds.has(id),
          mini: true,
          onChange: function onChange(event) {
            var checked = event.target.checked;
            var nextVisibleColumns = sortedColumns.filter(function (columnId) {
              return checked ? visibleColumnIds.has(columnId) || id === columnId : visibleColumnIds.has(columnId) && id !== columnId;
            });
            setVisibleColumns(nextVisibleColumns);
          },
          "data-test-subj": "dataGridColumnSelectorToggleColumnVisibility-".concat(id)
        })), ___EmotionJSX(EuiFlexItem
        // This extra column name flex item affords the column more grabbable real estate
        // for mouse users, while hiding repetition for keyboard/screen reader users
        , _extends({}, provided.dragHandleProps, {
          "aria-hidden": true,
          tabIndex: -1
        }), ___EmotionJSX(EuiText, {
          size: "xs",
          className: "euiDataGridColumnSelector__itemLabel"
        }, displayValues[id] || id)), isDragEnabled && ___EmotionJSX(EuiFlexItem, _extends({
          grow: false
        }, provided.dragHandleProps, {
          "aria-label": dragHandleAriaLabel
        }), ___EmotionJSX(EuiIcon, {
          type: "grab",
          color: "subdued"
        }))));
      });
    })))), allowColumnHiding && ___EmotionJSX(EuiPopoverFooter, {
      paddingSize: "s"
    }, ___EmotionJSX(EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      justifyContent: "spaceBetween"
    }, ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      onClick: function onClick() {
        return setVisibleColumns(sortedColumns);
      },
      "data-test-subj": "dataGridColumnSelectorShowAllButton"
    }, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSelector.selectAll",
      default: "Show all"
    }))), ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      onClick: function onClick() {
        return setVisibleColumns([]);
      },
      "data-test-subj": "dataGridColumnSelectorHideAllButton"
    }, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSelector.hideAll",
      default: "Hide all"
    })))))) : null;
  }, [styles, availableColumns.length, numberOfHiddenFields, orderedVisibleColumns.length, allowColumnHiding, allowColumnReorder, isOpen, columnSearchText, displayValues, visibleColumnIds, sortedColumns, setVisibleColumns, setIsOpen, onDragEnd, isDragEnabled, dragHandleAriaLabel, filteredColumns]);

  /**
   * Used for moving columns left/right, available in the headers actions menu
   */
  var switchColumnPos = useCallback(function (fromColId, toColId) {
    var moveFromIdx = sortedColumns.indexOf(fromColId);
    var moveToIdx = sortedColumns.indexOf(toColId);
    if (moveFromIdx === -1 || moveToIdx === -1) {
      return;
    }
    var nextSortedColumns = _toConsumableArray(sortedColumns);
    nextSortedColumns.splice(moveFromIdx, 1);
    nextSortedColumns.splice(moveToIdx, 0, fromColId);
    setColumns(nextSortedColumns);
  }, [setColumns, sortedColumns]);
  return useMemo(function () {
    return [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos];
  }, [columnSelector, orderedVisibleColumns, setVisibleColumns, switchColumnPos]);
};