/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiYScrollWithShadows, logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiShadowLarge } from '../../../themes';
export var euiDataGridColumnSelectorStyles = function euiDataGridColumnSelectorStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var maxStaticHeight = mathWithUnits(euiTheme.size.base, function (x) {
    return x * 25;
  });
  var maxResponsiveHeight = "min(".concat(maxStaticHeight, ", 50vh)");
  return {
    euiDataGridColumnSelector: /*#__PURE__*/css(euiYScrollWithShadows(euiThemeContext), " ", logicalCSS('max-height', maxResponsiveHeight), " padding:", euiTheme.size.s, ";;label:euiDataGridColumnSelector;"),
    euiDataGridColumnSelector__item: /*#__PURE__*/css("padding:", euiTheme.size.xs, ";&.euiDataGridColumnSelector__item-isDragging{", euiShadowLarge(euiThemeContext), " background-color:", euiTheme.colors.emptyShade, ";};label:euiDataGridColumnSelector__item;")
  };
};