import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["sorting"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState, useMemo, useCallback, memo } from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiButtonEmpty } from '../../button';
import { EuiDragDropContext, euiDragDropReorder, EuiDroppable } from '../../drag_and_drop';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiI18n, useEuiI18n } from '../../i18n';
import { EuiPopover, EuiPopoverFooter } from '../../popover';
import { EuiText } from '../../text';
import { EuiToken } from '../../token';
import { getDetailsForSchema } from '../utils/data_grid_schema';
import { EuiDataGridToolbarControl } from './data_grid_toolbar_control';
import { EuiDataGridColumnSortingDraggable } from './column_sorting_draggable';
import { euiDataGridColumnSortingStyles } from './column_sorting.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useDataGridColumnSorting = function useDataGridColumnSorting(_ref) {
  var sorting = _ref.sorting,
    rest = _objectWithoutProperties(_ref, _excluded);
  return sorting == null ? null : ___EmotionJSX(DataGridSortingControl, _extends({
    sorting: sorting
  }, rest));
};
export var DataGridSortingControl = /*#__PURE__*/memo(function (_ref2) {
  var columns = _ref2.columns,
    sorting = _ref2.sorting,
    schema = _ref2.schema,
    schemaDetectors = _ref2.schemaDetectors,
    displayValues = _ref2.displayValues;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var sortingButtonText = useEuiI18n('euiColumnSorting.button', 'Sort fields');
  var sortFieldAriaLabel = useEuiI18n('euiColumnSorting.sortFieldAriaLabel', 'Sort by: ');
  var styles = useEuiMemoizedStyles(euiDataGridColumnSortingStyles);
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    availableColumnsIsOpen = _useState4[0],
    setAvailableColumnsIsOpen = _useState4[1];
  var availableColumnIds = useMemo(function () {
    return new Set(columns.map(function (_ref3) {
      var id = _ref3.id;
      return id;
    }));
  }, [columns]);

  // prune any non-existent/hidden columns from sorting
  useEffect(function () {
    var nextSortingColumns = [];
    for (var i = 0; i < sorting.columns.length; i++) {
      var column = sorting.columns[i];
      if (availableColumnIds.has(column.id)) {
        nextSortingColumns.push(column);
      }
    }

    // if the column array lengths differ then the sorting columns have been pruned
    if (nextSortingColumns.length !== sorting.columns.length) {
      sorting.onSort(nextSortingColumns);
    }
  }, [availableColumnIds, sorting]);
  var _useMemo = useMemo(function () {
      var activeColumnIds = new Set(sorting.columns.map(function (_ref4) {
        var id = _ref4.id;
        return id;
      }));
      return columns.reduce(function (acc, column) {
        if (activeColumnIds.has(column.id)) {
          acc.activeColumns.push(column);
        } else {
          acc.inactiveColumns.push(column);
        }
        return acc;
      }, {
        activeColumns: [],
        inactiveColumns: []
      });
    }, [columns, sorting]),
    inactiveColumns = _useMemo.inactiveColumns;
  var onDragEnd = useCallback(function (_ref5) {
    var sourceIndex = _ref5.source.index,
      destination = _ref5.destination;
    if (destination) {
      var destinationIndex = destination.index;
      var nextColumns = euiDragDropReorder(sorting.columns, sourceIndex, destinationIndex);
      sorting.onSort(nextColumns);
    }
  }, [sorting]);
  var schemaDetails = useCallback(function (id) {
    return schema.hasOwnProperty(id) && schema[id].columnType != null ? getDetailsForSchema(schemaDetectors, schema[id].columnType) : null;
  }, [schema, schemaDetectors]);
  var inactiveSortableColumns = useMemo(function () {
    return inactiveColumns.filter(function (_ref6) {
      var id = _ref6.id,
        isSortable = _ref6.isSortable;
      var schemaDetail = schemaDetails(id);
      var sortable = true;
      if (isSortable != null) {
        sortable = isSortable;
      } else if (schemaDetail != null) {
        sortable = schemaDetail.hasOwnProperty('isSortable') ? schemaDetail.isSortable : true;
      }
      return sortable;
    });
  }, [inactiveColumns, schemaDetails]);
  var onButtonClick = useCallback(function (id, defaultSortDirection) {
    var _schemaDetails;
    var nextColumns = _toConsumableArray(sorting.columns);
    nextColumns.push({
      id: id,
      direction: defaultSortDirection || ((_schemaDetails = schemaDetails(id)) === null || _schemaDetails === void 0 ? void 0 : _schemaDetails.defaultSortDirection) || 'asc'
    });
    sorting.onSort(nextColumns);
  }, [sorting, schemaDetails]);
  return ___EmotionJSX(EuiPopover, {
    "data-test-subj": "dataGridColumnSortingPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downLeft",
    panelPaddingSize: "s",
    button: ___EmotionJSX(EuiDataGridToolbarControl, {
      badgeContent: sorting.columns.length,
      iconType: "sortable",
      "data-test-subj": "dataGridColumnSortingButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      }
    }, sortingButtonText)
  }, sorting.columns.length > 0 ? ___EmotionJSX(EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, ___EmotionJSX(EuiDroppable, {
    droppableId: "columnSorting",
    css: styles.euiDataGridColumnSorting
  }, ___EmotionJSX(React.Fragment, null, sorting.columns.map(function (_ref7, index) {
    var id = _ref7.id,
      direction = _ref7.direction;
    return ___EmotionJSX(EuiDataGridColumnSortingDraggable, {
      key: id,
      id: id,
      display: displayValues[id],
      direction: direction,
      index: index,
      sorting: sorting,
      schema: schema,
      schemaDetectors: schemaDetectors
    });
  })))) : ___EmotionJSX(EuiText, {
    size: "s",
    color: "subdued"
  }, ___EmotionJSX("p", {
    role: "alert"
  }, ___EmotionJSX(EuiI18n, {
    token: "euiColumnSorting.emptySorting",
    default: "Currently no fields are sorted"
  }))), (inactiveSortableColumns.length > 0 || sorting.columns.length > 0) && ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween",
    responsive: false
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, inactiveSortableColumns.length > 0 && ___EmotionJSX(EuiPopover, {
    "data-test-subj": "dataGridColumnSortingPopoverColumnSelection",
    isOpen: availableColumnsIsOpen,
    closePopover: function closePopover() {
      return setAvailableColumnsIsOpen(false);
    },
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    button: ___EmotionJSX(EuiButtonEmpty, {
      size: "xs",
      flush: "left",
      iconType: "arrowDown",
      iconSide: "right",
      "data-test-subj": "dataGridColumnSortingSelectionButton",
      onClick: function onClick() {
        return setAvailableColumnsIsOpen(!availableColumnsIsOpen);
      }
    }, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSorting.pickFields",
      default: "Pick fields to sort by"
    }))
  }, ___EmotionJSX("div", {
    css: styles.euiDataGridColumnSorting__fieldList,
    className: "euiDataGridColumnSorting__fieldList",
    role: "listbox"
  }, inactiveSortableColumns.map(function (_ref8) {
    var id = _ref8.id,
      defaultSortDirection = _ref8.defaultSortDirection;
    return ___EmotionJSX("button", {
      key: id,
      css: styles.euiDataGridColumnSorting__field,
      className: "euiDataGridColumnSorting__field",
      "aria-label": "".concat(sortFieldAriaLabel, " ").concat(id),
      role: "option",
      "aria-selected": "false",
      "data-test-subj": "dataGridColumnSortingPopoverColumnSelection-".concat(id),
      onClick: function onClick() {
        return onButtonClick(id, defaultSortDirection);
      }
    }, ___EmotionJSX(EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      component: "span",
      responsive: false
    }, ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiToken, {
      iconType: schemaDetails(id) != null ? getDetailsForSchema(schemaDetectors, schema[id].columnType).icon : 'tokenString',
      color: schemaDetails(id) != null ? getDetailsForSchema(schemaDetectors, schema[id].columnType).color : undefined
    })), ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiText, {
      size: "xs"
    }, displayValues[id]))));
  })))), sorting.columns.length > 0 ? ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: function onClick() {
      return sorting.onSort([]);
    },
    "data-test-subj": "dataGridColumnSortingClearButton"
  }, ___EmotionJSX(EuiI18n, {
    token: "euiColumnSorting.clearAll",
    default: "Clear sorting"
  }))) : null)));
});
DataGridSortingControl.displayName = 'DataGridSortingControl';