/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiMinBreakpoint, euiYScroll, euiYScrollWithShadows, logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiShadowLarge } from '../../../themes';
export var euiDataGridColumnSortingStyles = function euiDataGridColumnSortingStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var maxStaticHeight = mathWithUnits(euiTheme.size.m, function (x) {
    return x * 25;
  });
  var maxResponsiveHeight = "min(".concat(maxStaticHeight, ", 75vh)");
  return {
    /**
     * Sorted fields
     */
    euiDataGridColumnSorting: /*#__PURE__*/css(logicalCSS('max-height', maxResponsiveHeight), " ", logicalCSS('padding-vertical', euiTheme.size.s), "margin:-", euiTheme.size.s, ";", euiYScrollWithShadows(euiThemeContext), ";;label:euiDataGridColumnSorting;"),
    euiDataGridColumnSorting__item: /*#__PURE__*/css(logicalCSS('padding-horizontal', euiTheme.size.s), " &.euiDataGridColumnSorting__item-isDragging{", euiShadowLarge(euiThemeContext), " background-color:", euiTheme.colors.emptyShade, ";};label:euiDataGridColumnSorting__item;"),
    euiDataGridColumnSorting__name: /*#__PURE__*/css(logicalCSS('padding-right', euiTheme.size.xs), " ", euiMinBreakpoint(euiThemeContext, 'm'), "{", logicalCSS('padding-right', euiTheme.size.l), ";};label:euiDataGridColumnSorting__name;"),
    euiDataGridColumnSorting__order: /*#__PURE__*/css(euiMinBreakpoint(euiThemeContext, 'm'), "{", logicalCSS('min-width', mathWithUnits(euiTheme.size.xxl, function (x) {
      return x * 5;
    })), ";}.euiButtonGroup__buttons{border:none;}.euiButtonGroupButton{font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";};label:euiDataGridColumnSorting__order;"),
    euiDataGridColumnSorting__dragHandle: /*#__PURE__*/css(logicalCSS('padding-right', euiTheme.size.xs), ";;label:euiDataGridColumnSorting__dragHandle;"),
    /**
     * 'Pick fields to sort by' popover
     */
    euiDataGridColumnSorting__fieldList: /*#__PURE__*/css("display:flex;flex-direction:column;padding-block:", euiTheme.size.xs, ";", logicalCSS('max-height', maxResponsiveHeight), " ", euiYScroll(euiThemeContext), ";;label:euiDataGridColumnSorting__fieldList;"),
    euiDataGridColumnSorting__field: /*#__PURE__*/css("padding-block:", euiTheme.size.xs, ";padding-inline:", euiTheme.size.s, ";outline-offset:-", euiTheme.focus.width, ";;label:euiDataGridColumnSorting__field;")
  };
};