import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "display", "direction", "index", "sorting", "schema", "schemaDetectors"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiButtonGroup, EuiButtonIcon } from '../../button';
import { EuiDraggable } from '../../drag_and_drop';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiI18n, useEuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiText } from '../../text';
import { EuiToken } from '../../token';
import { getDetailsForSchema } from '../utils/data_grid_schema';
import { euiDataGridColumnSortingStyles } from './column_sorting.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var defaultSortAscLabel = ___EmotionJSX(EuiI18n, {
  token: "euiColumnSortingDraggable.defaultSortAsc",
  default: "A-Z"
});
export var defaultSortDescLabel = ___EmotionJSX(EuiI18n, {
  token: "euiColumnSortingDraggable.defaultSortDesc",
  default: "Z-A"
});
export var EuiDataGridColumnSortingDraggable = function EuiDataGridColumnSortingDraggable(_ref) {
  var id = _ref.id,
    display = _ref.display,
    direction = _ref.direction,
    index = _ref.index,
    sorting = _ref.sorting,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    rest = _objectWithoutProperties(_ref, _excluded);
  var schemaDetails = schema.hasOwnProperty(id) && schema[id].columnType != null ? getDetailsForSchema(schemaDetectors, schema[id].columnType) : null;
  var textSortAsc = schemaDetails != null ? schemaDetails.sortTextAsc : defaultSortAscLabel;
  var textSortDesc = schemaDetails != null ? schemaDetails.sortTextDesc : defaultSortDescLabel;
  var toggleOptions = [{
    id: "".concat(id, "Asc"),
    value: 'asc',
    label: textSortAsc,
    'data-test-subj': "euiDataGridColumnSorting-sortColumn-".concat(id, "-asc")
  }, {
    id: "".concat(id, "Desc"),
    value: 'desc',
    label: textSortDesc,
    'data-test-subj': "euiDataGridColumnSorting-sortColumn-".concat(id, "-desc")
  }];
  var dragHandleAriaLabel = useEuiI18n('euiColumnSortingDraggable.dragHandleAriaLabel', 'Drag handle');
  var removeSort = useCallback(function () {
    var nextColumns = _toConsumableArray(sorting.columns);
    var columnIndex = nextColumns.map(function (_ref2) {
      var id = _ref2.id;
      return id;
    }).indexOf(id);
    nextColumns.splice(columnIndex, 1);
    sorting.onSort(nextColumns);
  }, [id, sorting]);
  var toggleLegendHandler = useCallback(function (_, direction) {
    var nextColumns = _toConsumableArray(sorting.columns);
    var columnIndex = nextColumns.map(function (_ref3) {
      var id = _ref3.id;
      return id;
    }).indexOf(id);
    nextColumns.splice(columnIndex, 1, {
      id: id,
      direction: direction
    });
    sorting.onSort(nextColumns);
  }, [id, sorting]);
  var styles = useEuiMemoizedStyles(euiDataGridColumnSortingStyles);
  return ___EmotionJSX(EuiDraggable, _extends({
    draggableId: id,
    index: index,
    hasInteractiveChildren: true,
    customDragHandle: true,
    usePortal: true
  }, rest), function (provided, state) {
    return ___EmotionJSX(EuiFlexGroup, {
      css: styles.euiDataGridColumnSorting__item,
      className: classNames('euiDataGridColumnSorting__item', {
        'euiDataGridColumnSorting__item-isDragging': state.isDragging
      }),
      gutterSize: "xs",
      alignItems: "center",
      responsive: false,
      "data-test-subj": "euiDataGridColumnSorting-sortColumn-".concat(id)
    }, ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSortingDraggable.activeSortLabel",
      default: "{display} is sorting this data grid",
      values: {
        display: display
      }
    }, function (activeSortLabel) {
      return activeSortLabel;
    }))), ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSortingDraggable.removeSortLabel",
      default: "Remove {display} from data grid sort",
      values: {
        display: display
      }
    }, function (removeSortLabel) {
      return ___EmotionJSX(EuiButtonIcon, {
        color: "text",
        className: "euiDataGridColumnSorting__button",
        "aria-label": removeSortLabel,
        iconType: "cross",
        onClick: removeSort
      });
    })), ___EmotionJSX(EuiFlexItem
    // This extra column name flex item affords the column more grabbable real estate
    // for mouse users, while hiding repetition for keyboard/screen reader users
    , _extends({
      css: styles.euiDataGridColumnSorting__name,
      className: "euiDataGridColumnSorting__name"
    }, provided.dragHandleProps, {
      tabIndex: -1,
      "aria-hidden": true
    }), ___EmotionJSX(EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiToken, {
      color: schemaDetails != null ? schemaDetails.color : undefined,
      iconType: schemaDetails != null ? schemaDetails.icon : 'tokenString'
    })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiText, {
      size: "xs"
    }, display)))), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiI18n, {
      token: "euiColumnSortingDraggable.toggleLegend",
      default: "Select sorting method for {display}",
      values: {
        display: display
      }
    }, function (toggleLegend) {
      return ___EmotionJSX(EuiButtonGroup, {
        legend: toggleLegend,
        isFullWidth: true,
        options: toggleOptions,
        buttonSize: "compressed",
        css: styles.euiDataGridColumnSorting__order,
        className: "euiDataGridColumnSorting__order",
        idSelected: direction === 'asc' ? "".concat(id, "Asc") : "".concat(id, "Desc"),
        onChange: toggleLegendHandler
      });
    })), ___EmotionJSX(EuiFlexItem, _extends({
      grow: false
    }, provided.dragHandleProps, {
      "aria-label": dragHandleAriaLabel
    }), ___EmotionJSX(EuiIcon, {
      type: "grab",
      color: "subdued"
    })));
  });
};