import _typeof from "@babel/runtime/helpers/typeof";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement } from 'react';
import { IS_JEST_ENVIRONMENT } from '../../../utils';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiScreenReaderOnly } from '../../accessibility';
import { euiDataGridToolbarStyles } from './data_grid_toolbar.styles';

// When below this number the grid only shows the right control icon buttons
import { jsx as ___EmotionJSX } from "@emotion/react";
export var MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479;
export var EuiDataGridToolbar = function EuiDataGridToolbar(_ref) {
  var gridWidth = _ref.gridWidth,
    _ref$minSizeForContro = _ref.minSizeForControls,
    minSizeForControls = _ref$minSizeForContro === void 0 ? MINIMUM_WIDTH_FOR_GRID_CONTROLS : _ref$minSizeForContro,
    toolbarVisibility = _ref.toolbarVisibility,
    isFullScreen = _ref.isFullScreen,
    fullScreenSelector = _ref.fullScreenSelector,
    keyboardShortcuts = _ref.keyboardShortcuts,
    displaySelector = _ref.displaySelector,
    columnSelector = _ref.columnSelector,
    columnSorting = _ref.columnSorting,
    renderCustomToolbar = _ref.renderCustomToolbar;
  var styles = useEuiMemoizedStyles(euiDataGridToolbarStyles);

  // Enables/disables grid controls based on available width
  var hasRoomForGridControls = IS_JEST_ENVIRONMENT ? true : gridWidth > minSizeForControls || isFullScreen;
  var columnControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showColumnSelector') ? columnSelector : null;
  var columnSortingControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showSortSelector') ? columnSorting : null;
  var keyboardShortcutsControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showKeyboardShortcuts') ? keyboardShortcuts : ___EmotionJSX(EuiScreenReaderOnly, {
    showOnFocus: true
  }, ___EmotionJSX("span", null, keyboardShortcuts));
  var displayControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showDisplaySelector') ? displaySelector : null;
  var fullScreenControl = checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showFullScreenSelector') ? fullScreenSelector : null;
  if (renderCustomToolbar) {
    return renderCustomToolbar({
      hasRoomForGridControls: hasRoomForGridControls,
      columnControl: columnControl,
      columnSortingControl: columnSortingControl,
      keyboardShortcutsControl: keyboardShortcutsControl,
      displayControl: displayControl,
      fullScreenControl: fullScreenControl
    });
  }
  return ___EmotionJSX("div", {
    css: styles.euiDataGrid__controls,
    className: "euiDataGrid__controls",
    "data-test-subj": "dataGridControls"
  }, hasRoomForGridControls && ___EmotionJSX("div", {
    css: styles.euiDataGrid__leftControls,
    className: "euiDataGrid__leftControls"
  }, renderAdditionalControls(toolbarVisibility, 'left.prepend'), columnControl, columnSortingControl, renderAdditionalControls(toolbarVisibility, 'left.append')), ___EmotionJSX("div", {
    css: styles.euiDataGrid__rightControls,
    className: "euiDataGrid__rightControls"
  }, renderAdditionalControls(toolbarVisibility, 'right'), keyboardShortcutsControl, displayControl, fullScreenControl));
};

/**
 * Toolbar utilities
 */

// Typeguards to see if toolbarVisibility has a certain boolean property assigned
// If not, just set it to true and assume it's OK to show
function objectHasKey(object, key) {
  return object.hasOwnProperty(key);
}
export function checkOrDefaultToolBarDisplayOptions(arg, option) {
  if (arg === undefined) {
    return true;
  } else if (typeof arg === 'boolean') {
    return arg;
  } else if (objectHasKey(arg, option)) {
    return arg[option];
  } else {
    return true;
  }
}
export var renderAdditionalControls = function renderAdditionalControls(toolbarVisibility, position) {
  if (typeof toolbarVisibility === 'boolean') return null;
  var _ref2 = toolbarVisibility || {},
    additionalControls = _ref2.additionalControls;
  if (!additionalControls) return null;

  // API backwards compatability: if the consumer passed a single ReactNode
  // to `additionalControls`, default to the left append position.
  if ( /*#__PURE__*/isValidElement(additionalControls) && position === 'left.append') {
    return additionalControls;
  }
  if (_typeof(additionalControls) !== 'object') {
    return null;
  }
  var handleLeftObjectConfig = function handleLeftObjectConfig(leftConfig) {
    if (position === 'left.prepend') {
      return leftConfig.prepend;
    }
    if (position === 'left.append') {
      return leftConfig.append;
    }
  };
  var handleObjectConfig = function handleObjectConfig(additionalControls) {
    if (position === 'right') {
      return additionalControls.right;
    }
    // API backwards compatability: If the consumer passed a single ReactNode
    // to `additionalControls.left`, default to the left append position
    if ( /*#__PURE__*/isValidElement(additionalControls.left) && position === 'left.append') {
      return additionalControls.left;
    }
    if (additionalControls.left && _typeof(additionalControls.left) === 'object') {
      return handleLeftObjectConfig(additionalControls.left);
    }
  };
  var rendered = handleObjectConfig(additionalControls);
  return rendered || null;
};

/**
 * Utility helper for selectors/controls that allow nested options
 * (e.g. column selector, display selector)
 */

export function getNestedObjectOptions(controlOption, objectKey) {
  var _controlOption$object;
  // If the config is a boolean, nested options follow that boolean
  if (typeof controlOption === 'boolean') return controlOption;
  // If config is not defined, default to enabled
  if (controlOption == null) return true;
  // Otherwise, type should be an object of boolean values - dive into it and return the value
  return !!((_controlOption$object = controlOption[objectKey]) !== null && _controlOption$object !== void 0 ? _controlOption$object : true);
}