import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "badgeContent", "textProps"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { css } from '@emotion/react';
import { EuiButtonEmpty } from '../../button';
import { EuiNotificationBadge } from '../../badge';
import { useEuiI18n } from '../../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridToolbarControl = function EuiDataGridToolbarControl(_ref) {
  var children = _ref.children,
    className = _ref.className,
    badgeContent = _ref.badgeContent,
    textProps = _ref.textProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiDataGridToolbarControl', className);
  var badgeAriaLabel = useEuiI18n('euiDataGridToolbarControl.badgeAriaLabel', 'Active: {count}', {
    count: typeof badgeContent === 'string' ? betterScreenReaderSlashes(badgeContent) : badgeContent
  });
  return ___EmotionJSX(EuiButtonEmpty, _extends({
    className: classes,
    size: "xs",
    color: "text",
    textProps: false,
    css: underlineStyles
  }, rest), ___EmotionJSX("span", _extends({}, textProps, {
    className: classNames('euiDataGridToolbarControl__text', 'eui-textTruncate', textProps && textProps.className)
  }), children), Boolean(badgeContent) && ___EmotionJSX(EuiNotificationBadge, {
    className: "euiDataGridToolbarControl__badge",
    css: badgeStyles,
    color: "subdued",
    "aria-label": "- ".concat(badgeAriaLabel) // Punctuation helps add pauses for screen readers
    ,
    role: "marquee" // https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/marquee_role
  }, badgeContent));
};

// The columns control specifically passes (e.g.) `5/10` when some columns
// are being hidden. We can make this a bit more legible to SRs with this quick util
var betterScreenReaderSlashes = function betterScreenReaderSlashes(badgeContent) {
  return badgeContent.replaceAll('/', ' out of ');
};

// Underline actual text, but not the badge
var underlineStyles = process.env.NODE_ENV === "production" ? {
  name: "128tp1b-underlineStyles",
  styles: "&:focus,&:hover:not(:disabled){text-decoration:none;.euiDataGridToolbarControl__text{text-decoration:underline;}};label:underlineStyles;"
} : {
  name: "128tp1b-underlineStyles",
  styles: "&:focus,&:hover:not(:disabled){text-decoration:none;.euiDataGridToolbarControl__text{text-decoration:underline;}};label:underlineStyles;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var badgeStyles = process.env.NODE_ENV === "production" ? {
  name: "1968nw3-badgeStyles",
  styles: "cursor:inherit;label:badgeStyles;"
} : {
  name: "1968nw3-badgeStyles",
  styles: "cursor:inherit;label:badgeStyles;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};