import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useMemo, useCallback } from 'react';
import { keys, useEuiMemoizedStyles } from '../../../services';
import { EuiToolTip } from '../../tool_tip';
import { EuiButtonIcon } from '../../button';
import { useEuiI18n } from '../../i18n';
import { euiDataGridFullScreenStyles } from './fullscreen_selector.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var GRID_IS_FULLSCREEN_CLASSNAME = 'euiDataGrid__restrictBody';
export var useDataGridFullScreenSelector = function useDataGridFullScreenSelector() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var _useEuiI18n = useEuiI18n(['euiFullscreenSelector.fullscreenButton', 'euiFullscreenSelector.fullscreenButtonActive'], ['Enter fullscreen', 'Exit fullscreen']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    fullScreenButton = _useEuiI18n2[0],
    fullScreenButtonActive = _useEuiI18n2[1];
  var fullScreenSelector = useMemo(function () {
    return ___EmotionJSX(EuiToolTip, {
      content: isFullScreen ? ___EmotionJSX(React.Fragment, null, fullScreenButtonActive, " (", ___EmotionJSX("kbd", null, "esc"), ")") : fullScreenButton,
      delay: "long"
    }, ___EmotionJSX(EuiButtonIcon, {
      size: "xs",
      iconType: isFullScreen ? 'fullScreenExit' : 'fullScreen',
      color: "text",
      "aria-pressed": isFullScreen,
      "data-test-subj": "dataGridFullScreenButton",
      onClick: function onClick() {
        return setIsFullScreen(!isFullScreen);
      },
      "aria-label": isFullScreen ? fullScreenButtonActive : fullScreenButton
    }));
  }, [isFullScreen, fullScreenButton, fullScreenButtonActive]);
  var handleGridKeyDown = useCallback(function (event) {
    switch (event.key) {
      case keys.ESCAPE:
        if (isFullScreen) {
          event.preventDefault();
          setIsFullScreen(false);
        }
        break;
    }
  }, [isFullScreen]);
  var styles = useEuiMemoizedStyles(euiDataGridFullScreenStyles);
  useEffect(function () {
    // When the data grid is fullscreen, we add a class to the body to remove the extra scrollbar and stay above any fixed headers
    if (isFullScreen) {
      document.body.classList.add(GRID_IS_FULLSCREEN_CLASSNAME, styles.euiDataGrid__restrictBody);
      return function () {
        document.body.classList.remove(GRID_IS_FULLSCREEN_CLASSNAME, styles.euiDataGrid__restrictBody);
      };
    }
  }, [isFullScreen, styles.euiDataGrid__restrictBody]);
  return {
    isFullScreen: isFullScreen,
    setIsFullScreen: setIsFullScreen,
    fullScreenSelector: fullScreenSelector,
    handleGridKeyDown: handleGridKeyDown,
    fullScreenStyles: styles['euiDataGrid--fullScreen']
  };
};