/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/css';
import { logicalCSS } from '../../../global_styling';
export var euiDataGridFullScreenStyles = function euiDataGridFullScreenStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var fullScreenZIndex = Number(euiTheme.levels.header) - 1;
  return {
    'euiDataGrid--fullScreen': /*#__PURE__*/css("z-index:", fullScreenZIndex, ";position:fixed;inset:0;background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGrid--fullScreen;"),
    // This is a vanilla className applied to the <body> when fullscreen is enabled.
    // It removes extra scrollbars + tweaks components to account for fixed headers
    euiDataGrid__restrictBody: /*#__PURE__*/css(logicalCSS('height', '100vh'), " overflow:hidden;.euiHeader[data-fixed-header]{z-index:", fullScreenZIndex - 1, "!important;}.euiOverlayMask[data-relative-to-header='below']{", logicalCSS('top', '0'), ";}.euiFlyout{", logicalCSS('top', '0'), " ", logicalCSS('height', '100%'), ";};label:euiDataGrid__restrictBody;")
  };
};