import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo } from 'react';
import { useGeneratedHtmlId, useEuiMemoizedStyles } from '../../../services';
import { EuiButtonIcon } from '../../button';
import { EuiToolTip } from '../../tool_tip';
import { EuiPopover, EuiPopoverTitle } from '../../popover';
import { EuiDescriptionList } from '../../description_list';
import { EuiText } from '../../text';
import { useEuiI18n, EuiI18n } from '../../i18n';
import { euiDataGridKeyboardShortcutsStyles } from './keyboard_shortcuts.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useDataGridKeyboardShortcuts = function useDataGridKeyboardShortcuts() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var title = useEuiI18n('euiKeyboardShortcuts.title', 'Keyboard shortcuts');
  var titleId = useGeneratedHtmlId();
  var styles = useEuiMemoizedStyles(euiDataGridKeyboardShortcutsStyles);
  var keyboardShortcuts = useMemo(function () {
    return ___EmotionJSX(EuiPopover, {
      "data-test-subj": "dataGridKeyboardShortcutsPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downRight",
      panelPaddingSize: "none",
      button: ___EmotionJSX(EuiToolTip, {
        content: title,
        delay: "long"
      }, ___EmotionJSX(EuiButtonIcon, {
        size: "xs",
        iconType: "keyboard",
        color: "text",
        "data-test-subj": "dataGridKeyboardShortcutsButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        },
        "aria-label": title
      }))
    }, ___EmotionJSX(EuiPopoverTitle, {
      paddingSize: "s"
    }, ___EmotionJSX("h2", {
      id: titleId
    }, title)), ___EmotionJSX(EuiText, {
      css: styles.euiDataGrid__keyboardShortcuts,
      className: "euiDataGrid__keyboardShortcuts",
      size: "xs"
    }, ___EmotionJSX(EuiDescriptionList, {
      "aria-labelledby": titleId,
      type: "column",
      columnWidths: ['auto', 'auto'],
      align: "center",
      compressed: true,
      listItems: [{
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowTitle",
          default: "Up arrow"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowDescription",
          default: "Move one cell up"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowTitle",
          default: "Down arrow"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowDescription",
          default: "Move one cell down"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowTitle",
          default: "Right arrow"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowDescription",
          default: "Move one cell right"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowTitle",
          default: "Left arrow"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowDescription",
          default: "Move one cell left"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.homeDescription",
          default: "Move to the first cell of the current row"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.endDescription",
          default: "Move to the last cell of the current row"
        })
      }, {
        title: ___EmotionJSX(React.Fragment, null, ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        }))),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlHomeDescription",
          default: "Move to the first cell of the current page"
        })
      }, {
        title: ___EmotionJSX(React.Fragment, null, ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        }))),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlEndDescription",
          default: "Move to the last cell of the current page"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpTitle",
          default: "Page Up"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpDescription",
          default: "Go to the last row of the previous page"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownTitle",
          default: "Page Down"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownDescription",
          default: "Go to the first row of the next page"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.enterTitle",
          default: "Enter"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.enterDescription",
          default: "Open cell details and actions"
        })
      }, {
        title: ___EmotionJSX("kbd", null, ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.escapeTitle",
          default: "Escape"
        })),
        description: ___EmotionJSX(EuiI18n, {
          token: "euiKeyboardShortcuts.escapeDescription",
          default: "Close cell details and actions"
        })
      }]
    })));
  }, [isOpen, title, titleId, styles]);
  return {
    keyboardShortcuts: keyboardShortcuts
  };
};