/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiYScroll, logicalCSS, mathWithUnits } from '../../../global_styling';
export var euiDataGridKeyboardShortcutsStyles = function euiDataGridKeyboardShortcutsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiDataGrid__keyboardShortcuts: /*#__PURE__*/css(logicalCSS('max-height', '80vh'), " ", logicalCSS('max-width', mathWithUnits(euiTheme.size.xxl, function (x) {
      return x * 10;
    })), " padding:", euiTheme.size.m, ";", euiYScroll(euiThemeContext), " .euiDescriptionList{row-gap:0;};label:euiDataGrid__keyboardShortcuts;")
  };
};