import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _typeof from "@babel/runtime/helpers/typeof";
var _excluded = ["pagination", "sorting", "columnVisibility"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable storybook/default-exports, storybook/prefer-pascal-case */

import React, { useCallback, useEffect, useState } from 'react';
import { css } from '@emotion/react';
import { faker } from '@faker-js/faker';
import { EuiLink } from '../link';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiButtonIcon } from '../button';
import { EuiCheckbox } from '../form';
import { EuiBadge } from '../badge';
import { MINIMUM_WIDTH_FOR_GRID_CONTROLS } from './controls/data_grid_toolbar';
import { EuiDataGrid } from './data_grid';
import { jsx as ___EmotionJSX } from "@emotion/react";
faker.seed(42);

// NOTE: using faker.date.past() is not fully stable for VRT as the date is
// based on a years time distance (default 1 year) which updates with progressing time
// faker.seed() ensures the same date is output in the same time frame
// but after some time the time distance will generate a newer, closer date
// which then invalidates the VRT
var staticDates = [new Date('Tue Mar 19 2024 18:54:51 GMT+0100'), new Date('Mon Mar 25 2024 19:27:35 GMT+0100'), new Date('Sat Sep 09 2023 00:32:42 GMT+0200'), new Date('Wed Jun 14 2023 06:48:29 GMT+0200'), new Date('Mon Mar 04 2024 04:40:36 GMT+0100'), new Date('Mon Feb 05 2024 10:51:48 GMT+0100'), new Date('Mon Jun 19 2023 12:08:38 GMT+0200'), new Date('Wed Jul 26 2023 01:15:02 GMT+0200'), new Date('Wed Nov 08 2023 08:49:13 GMT+0100'), new Date('Sun Nov 19 2023 01:49:12 GMT+0100')];
var dataKeys = ['name', 'email', 'account', 'location', 'date', 'version'];
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1u596ek-version",
  styles: "vertical-align:text-bottom;label:version;"
} : {
  name: "1u596ek-version",
  styles: "vertical-align:text-bottom;label:version;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var raw_data = Array.from({
  length: 10
}).map(function (_, i) {
  var email = faker.internet.email();
  var name = "".concat(faker.person.lastName(), ", ").concat(faker.person.firstName());
  var date = staticDates[i].toDateString();
  var suffix = faker.person.suffix();
  return {
    name: {
      formatted: "".concat(name, " ").concat(suffix),
      raw: name
    },
    email: {
      formatted: ___EmotionJSX(EuiLink, {
        href: ""
      }, email),
      raw: email
    },
    location: ___EmotionJSX(React.Fragment, null, "".concat(faker.location.city(), ", "), ___EmotionJSX(EuiLink, {
      href: "https://google.com"
    }, faker.location.country())),
    date: date,
    account: faker.finance.accountNumber(),
    version: ___EmotionJSX(EuiBadge
    // Tweak the badge's vertical centering
    , {
      css: _ref
    }, faker.system.semver())
  };
});
var columns = [{
  id: 'name',
  displayAsText: 'Name',
  defaultSortDirection: 'asc',
  cellActions: [function (_ref2) {
    var rowIndex = _ref2.rowIndex,
      Component = _ref2.Component;
    var data = raw_data;
    var value = data[rowIndex].name.raw;
    return ___EmotionJSX(Component, {
      onClick: function onClick() {
        return alert("Hi ".concat(value));
      },
      iconType: "heart",
      "aria-label": "Say hi to ".concat(value, "!")
    }, "Say hi");
  }]
}, {
  id: 'email',
  displayAsText: 'Email address',
  initialWidth: 130,
  cellActions: [function (_ref3) {
    var rowIndex = _ref3.rowIndex,
      Component = _ref3.Component;
    var data = raw_data;
    var value = data[rowIndex].email.raw;
    return ___EmotionJSX(Component, {
      onClick: function onClick() {
        return alert(value);
      },
      iconType: "email",
      "aria-label": "Send email to ".concat(value)
    }, "Send email");
  }]
}, {
  id: 'account',
  displayAsText: 'Account',
  actions: {
    showHide: {
      label: 'Custom hide label'
    },
    showMoveLeft: false,
    showMoveRight: false,
    additional: [{
      label: 'Custom action',
      onClick: function onClick() {},
      iconType: 'cheer',
      size: 'xs',
      color: 'text'
    }]
  },
  cellActions: [function (_ref4) {
    var rowIndex = _ref4.rowIndex,
      Component = _ref4.Component,
      isExpanded = _ref4.isExpanded;
    var data = raw_data;
    var value = data[rowIndex].account;
    var onClick = isExpanded ? function () {
      return alert("Sent money to ".concat(value, " when expanded"));
    } : function () {
      return alert("Sent money to ".concat(value, " when not expanded"));
    };
    return ___EmotionJSX(Component, {
      onClick: onClick,
      iconType: "faceHappy",
      "aria-label": "Send money to ".concat(value)
    }, "Send money");
  }]
}, {
  id: 'location',
  displayAsText: 'Location'
}, {
  id: 'date',
  displayAsText: 'Date',
  defaultSortDirection: 'desc'
}, {
  id: 'version',
  displayAsText: 'Version',
  defaultSortDirection: 'desc',
  initialWidth: 70,
  isResizable: false,
  actions: false,
  schema: 'version' // Custom schema + CSS
}];
var RenderCellValue = function RenderCellValue(_ref5) {
  var rowIndex = _ref5.rowIndex,
    columnId = _ref5.columnId;
  var data = raw_data;
  var row = data[rowIndex];
  var columnName = columnId;
  var column = row[columnName];
  var getFormatted = function getFormatted() {
    if (_typeof(column) === 'object') {
      var hasFormatted = ('formatted' in column);
      return hasFormatted ? column.formatted : column;
    }
    return typeof column === 'string' ? column : null;
  };
  return data.hasOwnProperty(rowIndex) ? getFormatted() : null;
};
export var defaultStorybookArgs = {
  'aria-label': 'EuiDataGrid',
  css: process.env.NODE_ENV === "production" ? {
    name: "1h7lf59-css",
    styles: ".euiDataGridRowCell--version,.euiDataGridHeaderCell--version{text-align:center;};label:css;"
  } : {
    name: "1h7lf59-css",
    styles: ".euiDataGridRowCell--version,.euiDataGridHeaderCell--version{text-align:center;};label:css;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  columns: columns,
  rowCount: 10,
  renderCellValue: RenderCellValue,
  trailingControlColumns: [{
    id: 'trailing-actions',
    width: 64,
    headerCellRender: function headerCellRender() {
      return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, "Row actions"));
    },
    rowCellRender: function rowCellRender() {
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiButtonIcon, {
        iconType: "indexEdit",
        "aria-label": "Edit row"
      }), ___EmotionJSX(EuiButtonIcon, {
        iconType: "boxesHorizontal",
        "aria-label": "Open actions popover"
      }));
    }
  }],
  leadingControlColumns: [{
    id: 'leading-actions',
    width: 32,
    headerCellRender: function headerCellRender() {
      return ___EmotionJSX(EuiCheckbox, {
        id: "selectAll",
        "aria-label": "Select all rows",
        onChange: function onChange() {}
      });
    },
    rowCellRender: function rowCellRender(_ref6) {
      var rowIndex = _ref6.rowIndex;
      return ___EmotionJSX(EuiCheckbox, {
        id: "selectRow".concat(rowIndex),
        "aria-label": "Select row ".concat(rowIndex + 1),
        onChange: function onChange() {}
      });
    }
  }],
  // setup for easier testing/QA
  columnVisibility: {
    visibleColumns: ['name', 'email', 'account', 'location', 'date', 'amount', 'phone', 'version'],
    setVisibleColumns: function setVisibleColumns() {},
    canDragAndDropColumns: false
  },
  inMemory: {
    level: 'sorting'
  },
  pagination: {
    pageIndex: 0,
    pageSize: 10,
    pageSizeOptions: [10, 20, 50],
    onChangeItemsPerPage: function onChangeItemsPerPage() {},
    onChangePage: function onChangePage() {}
  },
  gridStyle: {
    fontSize: 'm',
    cellPadding: 'm',
    border: 'all',
    stripes: false,
    header: 'shade',
    footer: 'overline',
    stickyFooter: true,
    rowHover: 'highlight',
    rowClasses: {}
  },
  width: '',
  height: '',
  toolbarVisibility: {
    showColumnSelector: true,
    showDisplaySelector: true,
    showSortSelector: true,
    showKeyboardShortcuts: true,
    showFullScreenSelector: true,
    additionalControls: null
  },
  minSizeForControls: MINIMUM_WIDTH_FOR_GRID_CONTROLS,
  rowHeightsOptions: {
    defaultHeight: undefined,
    rowHeights: {},
    lineHeight: undefined,
    scrollAnchorRow: undefined
  }
};
export var StatefulDataGrid = function StatefulDataGrid(props) {
  var _pagination$pageIndex, _sorting$columns, _columnVisibility$vis;
  var pagination = props.pagination,
    sorting = props.sorting,
    columnVisibility = props.columnVisibility,
    rest = _objectWithoutProperties(props, _excluded);

  // Pagination
  var _useState = useState(_objectSpread({
      pageIndex: (_pagination$pageIndex = pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : 0
    }, pagination)),
    _useState2 = _slicedToArray(_useState, 2),
    _pagination = _useState2[0],
    setPagination = _useState2[1];
  var onChangeItemsPerPage = useCallback(function (pageSize) {
    return setPagination(function (pagination) {
      return _objectSpread(_objectSpread({}, pagination), {}, {
        pageSize: pageSize,
        pageIndex: 0
      });
    });
  }, [setPagination]);
  var onChangePage = useCallback(function (pageIndex) {
    return setPagination(function (pagination) {
      return _objectSpread(_objectSpread({}, pagination), {}, {
        pageIndex: pageIndex
      });
    });
  }, [setPagination]);
  useEffect(function () {
    if (pagination) {
      setPagination(function (curentPagination) {
        return _objectSpread(_objectSpread({}, curentPagination), pagination);
      });
    }
  }, [pagination]);

  // Sorting
  var _useState3 = useState((_sorting$columns = sorting === null || sorting === void 0 ? void 0 : sorting.columns) !== null && _sorting$columns !== void 0 ? _sorting$columns : []),
    _useState4 = _slicedToArray(_useState3, 2),
    sortingColumns = _useState4[0],
    setSortingColumns = _useState4[1];
  var onSort = useCallback(function (sortingColumns) {
    var _sorting$onSort;
    setSortingColumns(sortingColumns);
    sorting === null || sorting === void 0 || (_sorting$onSort = sorting.onSort) === null || _sorting$onSort === void 0 || _sorting$onSort.call(sorting, sortingColumns);
  }, [setSortingColumns, sorting]);
  useEffect(function () {
    if (sorting && Array.isArray(sorting.columns)) {
      setSortingColumns(sorting.columns);
    }
  }, [sorting]);

  // Column visibility
  var _useState5 = useState((_columnVisibility$vis = columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns) !== null && _columnVisibility$vis !== void 0 ? _columnVisibility$vis : columns.map(function (_ref7) {
      var id = _ref7.id;
      return id;
    }) // initialize to the full set of columns
    ),
    _useState6 = _slicedToArray(_useState5, 2),
    visibleColumns = _useState6[0],
    setVisibleColumns = _useState6[1];
  useEffect(function () {
    if ((columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns) != null) {
      setVisibleColumns(columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns);
    }
  }, [columnVisibility]);
  return ___EmotionJSX(EuiDataGrid, _extends({}, rest, {
    columnVisibility: {
      visibleColumns: visibleColumns,
      setVisibleColumns: setVisibleColumns,
      canDragAndDropColumns: columnVisibility.canDragAndDropColumns
    },
    sorting: {
      columns: sortingColumns,
      onSort: onSort
    },
    pagination: _objectSpread(_objectSpread({}, _pagination), {}, {
      onChangeItemsPerPage: onChangeItemsPerPage,
      onChangePage: onChangePage
    })
  }));
};

/*
 * Components that exist purely for allowing Storybook to parse certain nested
 * interfaces/types into specific example control tables.
 *
 * For whatever reason, they needs to be in a separate file for Storybook's
 * react-typescript-docgen to parse the jsdoc comments into the controls table
 */

export var EuiDataGridToolbarPropsComponent = function EuiDataGridToolbarPropsComponent() {
  return ___EmotionJSX(React.Fragment, null);
};
export var EuiDataGridStylePropsComponent = function EuiDataGridStylePropsComponent() {
  return ___EmotionJSX(React.Fragment, null);
};
export var EuiDataGridRowHeightsPropsComponent = function EuiDataGridRowHeightsPropsComponent() {
  return ___EmotionJSX(React.Fragment, null);
};