/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { tintOrShade } from '../../services';
import { euiFontSize, logicalCSS, logicalSizeCSS, mathWithUnits } from '../../global_styling';
export var euiDataGridVariables = function euiDataGridVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    cellPadding: {
      s: euiTheme.size.xs,
      m: mathWithUnits(euiTheme.size.m, function (x) {
        return x / 2;
      }),
      l: euiTheme.size.s
    },
    lineHeight: {
      s: euiFontSize(euiThemeContext, 'xs').lineHeight,
      m: euiFontSize(euiThemeContext, 'm').lineHeight
    },
    fontSize: {
      s: euiFontSize(euiThemeContext, 'xs').fontSize,
      m: euiFontSize(euiThemeContext, 's').fontSize
    },
    levels: {
      cellPopover: Number(euiTheme.levels.header),
      // Same z-index as EuiFlyout mask overlays - cell popovers should be under both modal and flyout overlays
      get stickyHeader() {
        return this.cellPopover - 1; // Needs to sit above the content + cell focus outlines/actions, but below actual popovers
      }
    }
  };
};
export var euiDataGridStyles = function euiDataGridStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    _cellPadding = _euiDataGridVariables.cellPadding,
    lineHeight = _euiDataGridVariables.lineHeight,
    _fontSize = _euiDataGridVariables.fontSize;
  return {
    euiDataGrid: /*#__PURE__*/css("display:flex;flex-direction:column;align-items:stretch;", logicalCSS('height', '100%'), " overflow:hidden;*:where(& .euiDataGridRow){background-color:", euiTheme.colors.emptyShade, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow--striped){background-color:", euiTheme.colors.lightestShade, ";}*:where(&.euiDataGrid--rowHoverHighlight .euiDataGridRow:hover){background-color:", euiTheme.colors.highlight, ";};label:euiDataGrid;"),
    cellPadding: {
      cellPadding: function cellPadding(size) {
        return /*#__PURE__*/css(".euiDataGridHeaderCell,.euiDataGridRowCell__content{padding:", _cellPadding[size], ";}/* Workaround to trim line-clamp and padding - @see https://github.com/elastic/eui/issues/7780 */.euiDataGridRowCell__content--lineCountHeight,.euiDataGridRowCell__content--autoBelowLineCountHeight{", logicalCSS('padding-bottom', 0), " ", logicalCSS('border-bottom', "".concat(_cellPadding[size], " solid transparent")), ";}.euiDataGridHeaderCell__button{margin-block:-", _cellPadding[size], ";};label:cellPadding;");
      },
      get s() {
        return /*#__PURE__*/css(this.cellPadding('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/css(this.cellPadding('m'), ";label:m;");
      },
      get l() {
        return /*#__PURE__*/css(this.cellPadding('l'), ";label:l;");
      }
    },
    fontSize: {
      fontSize: function fontSize(size) {
        return /*#__PURE__*/css(".euiDataGridHeaderCell,.euiDataGridRowCell{font-size:", _fontSize[size], ";line-height:", lineHeight[size], ";};label:fontSize;");
      },
      get s() {
        return /*#__PURE__*/css(this.fontSize('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/css(this.fontSize('m'), ";label:m;");
      },
      get l() {
        // On the Amsterdam theme, the l fontSize is the same as m
        return /*#__PURE__*/css(this.fontSize('m'), ";label:l;");
      }
    },
    borders: {
      none: null,
      horizontal: /*#__PURE__*/css("label:borders;.euiDataGridRowCell:not(.euiDataGridFooterCell),.euiDataGridFooter,&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", logicalCSS('border-bottom', euiTheme.border.thin), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", logicalCSS('border-top', euiTheme.border.thin), " ", logicalCSS('margin-top', "-".concat(euiTheme.border.width.thin)), ";}.euiDataGridHeader{", logicalCSS('border-top', euiTheme.border.thin), ";};label:horizontal;"),
      all: /*#__PURE__*/css("label:borders;.euiDataGridRowCell{&:not(.euiDataGridFooterCell){", logicalCSS('border-bottom', euiTheme.border.thin), " ", logicalCSS('border-right', // Visually lighten vertical borders
      "".concat(euiTheme.border.width.thin, " solid ").concat(tintOrShade(euiTheme.border.color, 0.3, colorMode))), ";}&--firstColumn{", logicalCSS('border-left', euiTheme.border.thin), ";}&--lastColumn{", logicalCSS('border-right-color', euiTheme.border.color), ";}}.euiDataGridFooterCell,.euiDataGridHeaderCell{", logicalCSS('border-right', euiTheme.border.thin), " &:first-of-type{", logicalCSS('border-left', euiTheme.border.thin), ";}}.euiDataGridFooter{", logicalCSS('border-bottom', euiTheme.border.thin), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", logicalCSS('border-top', euiTheme.border.thin), " ", logicalCSS('margin-top', "-".concat(euiTheme.border.width.thin)), ";}&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", logicalCSS('border-bottom', euiTheme.border.thin), ";}&:is(.euiDataGrid--noControls) .euiDataGridHeader{", logicalCSS('border-top', euiTheme.border.thin), ";}.euiDataGrid__controls{border:", euiTheme.border.thin, ";background-color:", euiTheme.colors.body, ";};label:all;")
    },
    // Sits below the controls above it and pagination below it
    euiDataGrid__content: /*#__PURE__*/css("z-index:1;position:relative;flex-grow:1;", logicalSizeCSS('100%'), " ", logicalCSS('max-width', '100%'), " overflow:hidden;font-feature-settings:'tnum' 1;;label:euiDataGrid__content;"),
    // Wrapper around EuiDataGrid
    euiDataGrid__focusWrap: /*#__PURE__*/css(logicalCSS('height', '100%'), ";;label:euiDataGrid__focusWrap;")
  };
};