import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useContext } from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { useEuiI18n } from '../../i18n';
import { EuiTablePagination } from '../../table/table_pagination';
import { DataGridFocusContext } from '../utils/focus';
import { euiDataGridPaginationStyles } from './data_grid_pagination.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Do not render the pagination when:
 * 1. Rows count is less than min pagination option (rows per page)
 * 2. Rows count is less than pageSize (the case when there are no pageSizeOptions provided)
 */
export var shouldRenderPagination = function shouldRenderPagination(rowCount, _ref) {
  var pageSize = _ref.pageSize,
    pageSizeOptions = _ref.pageSizeOptions;
  var minSizeOption = _toConsumableArray(pageSizeOptions).sort(function (a, b) {
    return a - b;
  })[0];
  return !(rowCount < (minSizeOption || pageSize));
};
export var EuiDataGridPagination = function EuiDataGridPagination(_ref2) {
  var pageIndex = _ref2.pageIndex,
    pageSize = _ref2.pageSize,
    pageSizeOptions = _ref2.pageSizeOptions,
    _onChangePage = _ref2.onChangePage,
    onChangeItemsPerPage = _ref2.onChangeItemsPerPage,
    rowCount = _ref2.rowCount,
    controls = _ref2.controls,
    ariaLabel = _ref2['aria-label'];
  var styles = useEuiMemoizedStyles(euiDataGridPaginationStyles);
  var detailedPaginationLabel = useEuiI18n('euiDataGridPagination.detailedPaginationLabel', 'Pagination for preceding grid: {label}', {
    label: ariaLabel !== null && ariaLabel !== void 0 ? ariaLabel : ''
  });
  var paginationLabel = useEuiI18n('euiDataGridPagination.paginationLabel', 'Pagination for preceding grid');

  // Focus the first data cell & scroll back to the top of the grid whenever paginating to a new page
  var _useContext = useContext(DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell;
  var onChangePage = useCallback(function (pageIndex) {
    _onChangePage(pageIndex);
    setFocusedCell([0, 0]);
  }, [setFocusedCell, _onChangePage]);
  var pageCount = pageSize ? Math.ceil(rowCount / pageSize) : 1;
  return ___EmotionJSX("div", {
    css: styles.euiDataGrid__pagination,
    className: "euiDataGrid__pagination"
  }, ___EmotionJSX(EuiTablePagination, {
    "aria-controls": controls,
    activePage: pageIndex,
    itemsPerPage: pageSize,
    itemsPerPageOptions: pageSizeOptions,
    showPerPageOptions: pageSizeOptions.length > 0,
    pageCount: pageCount,
    onChangePage: onChangePage,
    onChangeItemsPerPage: onChangeItemsPerPage,
    "aria-label": ariaLabel ? detailedPaginationLabel : paginationLabel
  }));
};