import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useMemo, useCallback, useState } from 'react';
import { useUpdateEffect } from '../../../services';
import { IS_JEST_ENVIRONMENT } from '../../../utils';
var DEFAULT_COLUMN_WIDTH = 100;
export var useDefaultColumnWidth = function useDefaultColumnWidth(gridWidth, leadingControlColumns, trailingControlColumns, columns) {
  var defaultColumnWidth = useMemo(function () {
    if (IS_JEST_ENVIRONMENT) return DEFAULT_COLUMN_WIDTH;
    if (gridWidth === 0) return null; // we can't tell what size to compute yet

    var controlColumnWidths = [].concat(_toConsumableArray(leadingControlColumns), _toConsumableArray(trailingControlColumns)).reduce(function (claimedWidth, controlColumn) {
      return claimedWidth + controlColumn.width;
    }, 0);
    var columnsWithWidths = columns.filter(doesColumnHaveAnInitialWidth);
    var definedColumnsWidth = columnsWithWidths.reduce(function (claimedWidth, column) {
      return claimedWidth + column.initialWidth;
    }, 0);
    var claimedWidth = controlColumnWidths + definedColumnsWidth;
    var widthToFill = gridWidth - claimedWidth;
    var unsizedColumnCount = columns.length - columnsWithWidths.length;
    if (unsizedColumnCount === 0) {
      return DEFAULT_COLUMN_WIDTH;
    }
    return Math.max(widthToFill / unsizedColumnCount, DEFAULT_COLUMN_WIDTH);
  }, [gridWidth, columns, leadingControlColumns, trailingControlColumns]);
  return defaultColumnWidth;
};
export var doesColumnHaveAnInitialWidth = function doesColumnHaveAnInitialWidth(column) {
  return column.hasOwnProperty('initialWidth') && column.initialWidth != null;
};
export var useColumnWidths = function useColumnWidths(_ref) {
  var columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    defaultColumnWidth = _ref.defaultColumnWidth,
    onColumnResize = _ref.onColumnResize;
  var computeColumnWidths = useCallback(function () {
    return columns.filter(doesColumnHaveAnInitialWidth).reduce(function (initialWidths, column) {
      return _objectSpread(_objectSpread({}, initialWidths), {}, _defineProperty({}, column.id, column.initialWidth));
    }, {});
  }, [columns]);

  // Passes initializer function for performance, so computing only runs once on init
  // @see https://react.dev/reference/react/useState#examples-initializer
  var _useState = useState(computeColumnWidths),
    _useState2 = _slicedToArray(_useState, 2),
    columnWidths = _useState2[0],
    setColumnWidths = _useState2[1];
  useUpdateEffect(function () {
    setColumnWidths(computeColumnWidths());
  }, [computeColumnWidths]);
  var setColumnWidth = useCallback(function (columnId, width) {
    setColumnWidths(function (prevColumnWidths) {
      return _objectSpread(_objectSpread({}, prevColumnWidths), {}, _defineProperty({}, columnId, width));
    });
    onColumnResize === null || onColumnResize === void 0 || onColumnResize({
      columnId: columnId,
      width: width
    });
  }, [onColumnResize]);

  // Used by react-window to determine actual column widths
  var getColumnWidth = useCallback(function (index) {
    // Leading control columns
    if (leadingControlColumns.length && index < leadingControlColumns.length) {
      return leadingControlColumns[index].width;
    }
    // Trailing control columns
    if (trailingControlColumns.length && index >= leadingControlColumns.length + columns.length) {
      return trailingControlColumns[index - leadingControlColumns.length - columns.length].width;
    }
    // Normal data columns
    var columnId = columns.length > 0 ? columns[index - leadingControlColumns.length].id : '';
    return columnWidths[columnId] || defaultColumnWidth || DEFAULT_COLUMN_WIDTH;
  }, [columns, leadingControlColumns, trailingControlColumns, columnWidths, defaultColumnWidth]);
  return {
    columnWidths: columnWidths,
    setColumnWidth: setColumnWidth,
    getColumnWidth: getColumnWidth
  };
};