import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useEffect, useMemo, useState, useRef } from 'react';
import { createPortal } from 'react-dom';
import { enqueueStateChange } from '../../../services/react';
import { EuiMutationObserver } from '../../observer/mutation_observer';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * inMemory values hook
 */
export var useInMemoryValues = function useInMemoryValues(inMemory, rowCount) {
  /**
   * For performance, `onCellRender` below mutates the inMemoryValues object
   * instead of cloning. If this operation were done in a setState call
   * React would ignore the update as the object itself has not changed.
   * So, we keep a dual record: the in-memory values themselves and a "version" counter.
   * When the object is mutated, the version is incremented triggering a re-render, and
   * the returned `inMemoryValues` object is re-created (cloned) from the mutated version.
   * The version updates are batched, so only one clone happens per batch.
   **/
  var _inMemoryValues = useRef({});
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    inMemoryValuesVersion = _useState2[0],
    setInMemoryValuesVersion = _useState2[1];
  var inMemoryValues = useMemo(function () {
    return _objectSpread({}, _inMemoryValues.current);
  }, [inMemoryValuesVersion] // eslint-disable-line react-hooks/exhaustive-deps
  );
  var onCellRender = useCallback(function (rowIndex, columnId, value) {
    var nextInMemoryValues = _inMemoryValues.current;
    nextInMemoryValues[rowIndex] = nextInMemoryValues[rowIndex] || {};
    if (nextInMemoryValues[rowIndex][columnId] !== value) {
      nextInMemoryValues[rowIndex][columnId] = value;
      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, []);

  // if `inMemory.level` or `rowCount` changes reset the values
  var inMemoryLevel = inMemory && inMemory.level;
  var resetRunCount = useRef(0);
  useEffect(function () {
    if (resetRunCount.current++ > 0) {
      // this has to delete "overflow" keys from the object instead of resetting to an empty one,
      // as the internal inmemoryrenderer component's useEffect which sets the values
      // executes before this outer, wrapping useEffect
      var existingRowKeyCount = Object.keys(_inMemoryValues.current).length;
      for (var i = rowCount; i < existingRowKeyCount; i++) {
        delete _inMemoryValues.current[i];
      }
      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, [inMemoryLevel, rowCount]);
  return [inMemoryValues, onCellRender];
};

/**
 * InMemory renderer
 */
export var EuiDataGridInMemoryRenderer = function EuiDataGridInMemoryRenderer(_ref) {
  var inMemory = _ref.inMemory,
    columns = _ref.columns,
    rowCount = _ref.rowCount,
    renderCellValue = _ref.renderCellValue,
    onCellRender = _ref.onCellRender;
  var _useState3 = useState(function () {
      return document.createDocumentFragment();
    }),
    _useState4 = _slicedToArray(_useState3, 1),
    documentFragment = _useState4[0];
  var cells = useMemo(function () {
    var CellElement = renderCellValue;
    var cells = [];
    var _loop = function _loop(i) {
      cells.push(columns.map(function (column, j) {
        var skipThisColumn = inMemory.skipColumns && inMemory.skipColumns.indexOf(column.id) !== -1;
        if (skipThisColumn) {
          return null;
        }
        var isExpandable = column.isExpandable !== undefined ? column.isExpandable : true;
        return ___EmotionJSX("div", {
          key: "".concat(i, "-").concat(column.id),
          "data-dg-row": i,
          "data-dg-column": column.id
        }, ___EmotionJSX(CellElement, {
          rowIndex: i,
          colIndex: j,
          columnId: column.id,
          setCellProps: noop,
          schema: column.schema,
          isExpandable: isExpandable,
          isExpanded: false,
          isDetails: false
        }));
      }).filter(function (cell) {
        return cell != null;
      }));
    };
    for (var i = 0; i < rowCount; i++) {
      _loop(i);
    }
    return cells;
  }, [rowCount, columns, inMemory.skipColumns, renderCellValue]);
  var onMutation = useCallback(function (records) {
    var _loop2 = function _loop2() {
      var record = records[i];
      var target = record.target;
      while (true) {
        if (target == null) return 1; // continue recordLoop
        // somehow hit the document fragment
        if (target.nodeType === Node.ELEMENT_NODE && target.hasAttribute('data-dg-row')) {
          // target is the cell wrapping div
          break;
        }
        target = target.parentElement;
      }
      var cellDiv = target;
      var rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);
      var column = cellDiv.getAttribute('data-dg-column');
      enqueueStateChange(function () {
        return onCellRender(rowIndex, column, getElementText(cellDiv));
      });
    };
    recordLoop: for (var i = 0; i < records.length; i++) {
      if (_loop2()) continue recordLoop;
    }
  }, [onCellRender]);
  useEffect(function () {
    var cellDivs = documentFragment.childNodes[0].childNodes;
    for (var i = 0; i < cellDivs.length; i++) {
      var cellDiv = cellDivs[i];
      var rowIndex = parseInt(cellDiv.getAttribute('data-dg-row'), 10);
      var column = cellDiv.getAttribute('data-dg-column');
      onCellRender(rowIndex, column, getElementText(cellDiv));
    }
    // changes to documentFragment.children is reflected by `cells`
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onCellRender, cells]);
  return /*#__PURE__*/createPortal(___EmotionJSX(EuiMutationObserver, {
    onMutation: onMutation,
    observerOptions: {
      characterData: true,
      subtree: true,
      attributes: true,
      childList: true
    }
  }, function (ref) {
    return ___EmotionJSX("div", {
      ref: ref
    }, cells);
  }), documentFragment);
};
function noop() {}
function getElementText(element) {
  return 'innerText' in element ? element.innerText :
  // (this line left here to satisfy Prettier since a ts-ignore is used on the next line)
  // @ts-ignore TypeScript thinks element.innerText always exists, however it doesn't in jest/jsdom environment
  element.textContent || '';
}