import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _get from "@babel/runtime/helpers/get";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { useCallback, useContext, useEffect, useMemo, useState } from 'react';
import { useForceRender, useLatest } from '../../../services';
import { isNumber, isObject } from '../../../services/predicate';
import { DataGridSortedContext } from './sorting';
var AUTO_HEIGHT = 'auto';
var DEFAULT_ROW_HEIGHT = 34;
export var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    var _this = this;
    _classCallCheck(this, RowHeightUtils);
    /**
     * Height types
     */
    _defineProperty(this, "getHeightType", function (option) {
      if (option == null) {
        return 'default';
      }
      if (option === AUTO_HEIGHT) {
        return 'auto';
      }
      var lineCount = _this.getLineCount(option);
      if (lineCount != null) {
        return lineCount > 1 ? 'lineCount' : 'default';
      }
      return 'numerical';
    });
    /**
     * Heights cache utils
     * This cache is primarily used by auto heights & secondarily used by lineCount row overrides
     */
    _defineProperty(this, "heightsCache", new Map());
  }
  return _createClass(RowHeightUtils, [{
    key: "getRowHeightOption",
    value: function getRowHeightOption(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro, _rowHeightsOptions$ro2;
      return (_rowHeightsOptions$ro = rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$ro2 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro2 === void 0 ? void 0 : _rowHeightsOptions$ro2[rowIndex]) !== null && _rowHeightsOptions$ro !== void 0 ? _rowHeightsOptions$ro : rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight;
    }
  }, {
    key: "isRowHeightOverride",
    value: function isRowHeightOverride(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro3;
      return (rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$ro3 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro3 === void 0 ? void 0 : _rowHeightsOptions$ro3[rowIndex]) != null;
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight, rowIndex, rowHeightsOptions) {
      if (isObject(heightOption) && heightOption.height) {
        return Math.max(heightOption.height, defaultHeight);
      }
      if (heightOption && isNumber(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }
      if (isObject(heightOption) && heightOption.lineCount) {
        var _ref = rowHeightsOptions || {},
          autoBelowLineCount = _ref.autoBelowLineCount; // uses auto height cache
        var isRowHeightOverride =
        // lineCount overrides are stored in the heights cache
        rowIndex != null && this.isRowHeightOverride(rowIndex, rowHeightsOptions);
        if (autoBelowLineCount || isRowHeightOverride) {
          return this.getRowHeight(rowIndex) || defaultHeight;
        } else {
          return defaultHeight; // default lineCount height is set in minRowHeight state in grid_row_body
        }
      }
      if (heightOption === AUTO_HEIGHT && rowIndex != null) {
        return this.getRowHeight(rowIndex);
      }
      return defaultHeight;
    }
  }, {
    key: "getLineCount",
    value:
    /**
     * Line count utils
     */

    function getLineCount(option) {
      return isObject(option) ? option.lineCount : undefined;
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(cellRef, lineCount) {
      var computedStyles = window.getComputedStyle(cellRef, null);
      var lineHeight = parseInt(computedStyles.lineHeight, 10);
      var contentHeight = Math.ceil(lineCount * lineHeight);
      var padding = parseInt(computedStyles.paddingTop, 10);

      // Assumes both padding-top and bottom are the same
      return contentHeight + padding * 2;
    }
  }, {
    key: "isAutoBelowLineCount",
    value: function isAutoBelowLineCount(options, option) {
      var _this$getLineCount;
      if (!(options !== null && options !== void 0 && options.autoBelowLineCount)) return false;
      if (((_this$getLineCount = this.getLineCount(option)) !== null && _this$getLineCount !== void 0 ? _this$getLineCount : 0) > 1) return true;
      return false;
    }

    /**
     * Auto height utils
     */
  }, {
    key: "isAutoHeight",
    value: function isAutoHeight(rowIndex, rowHeightsOptions) {
      var height = this.getRowHeightOption(rowIndex, rowHeightsOptions);
      if (height === AUTO_HEIGHT) {
        return true;
      }
      if (this.isAutoBelowLineCount(rowHeightsOptions, height)) {
        return true;
      }
      return false;
    }
  }, {
    key: "getRowHeight",
    value: function getRowHeight(rowIndex) {
      var rowHeights = this.heightsCache.get(rowIndex);
      if (rowHeights == null) return 0;
      var rowHeightValues = Array.from(rowHeights.values());
      if (!rowHeightValues.length) return 0;
      return Math.max.apply(Math, rowHeightValues);
    }
  }, {
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_ROW_HEIGHT;
      var _visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var rowHeights = this.heightsCache.get(rowIndex) || new Map();
      var adaptedHeight = Math.ceil(height);
      if (rowHeights.get(colId) === adaptedHeight) {
        return false;
      } else {
        rowHeights.set(colId, adaptedHeight);
        this.heightsCache.set(rowIndex, rowHeights);
        return true;
      }
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var visibleColumnIds = new Set(visibleColumns.map(function (_ref2) {
        var id = _ref2.id;
        return id;
      }));
      var didModify = false;
      this.heightsCache.forEach(function (rowHeights) {
        var existingColumnIds = Array.from(rowHeights.keys());
        existingColumnIds.forEach(function (existingColumnId) {
          if (visibleColumnIds.has(existingColumnId) === false) {
            didModify = true;
            rowHeights.delete(existingColumnId);
          }
        });
      });
      return didModify;
    }
  }]);
}();

/**
 * Row height utils with virtualization library-specific APIs
 */
export var RowHeightVirtualizationUtils = /*#__PURE__*/function (_RowHeightUtils2) {
  function RowHeightVirtualizationUtils(gridRef, outerGridElementRef, gridItemsRenderedRef, rerenderGridBodyRef) {
    var _this2;
    _classCallCheck(this, RowHeightVirtualizationUtils);
    _this2 = _callSuper(this, RowHeightVirtualizationUtils);
    /**
     * Virtualization workarounds for auto height rows
     */
    _defineProperty(_this2, "timerId", void 0);
    _defineProperty(_this2, "lastUpdatedRow", Infinity);
    _this2.gridRef = gridRef;
    _this2.outerGridElementRef = outerGridElementRef;
    _this2.gridItemsRenderedRef = gridItemsRenderedRef;
    _this2.rerenderGridBodyRef = rerenderGridBodyRef;
    return _this2;
  }
  _inherits(RowHeightVirtualizationUtils, _RowHeightUtils2);
  return _createClass(RowHeightVirtualizationUtils, [{
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_ROW_HEIGHT;
      var visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var didModify = _get(_getPrototypeOf(RowHeightVirtualizationUtils.prototype), "setRowHeight", this).call(this, rowIndex, colId, height, visibleRowIndex);

      // When an auto row height is updated, force a re-render
      // of the grid body to update the unconstrained height
      if (didModify) {
        var _this$rerenderGridBod, _this$rerenderGridBod2;
        (_this$rerenderGridBod = (_this$rerenderGridBod2 = this.rerenderGridBodyRef).current) === null || _this$rerenderGridBod === void 0 || _this$rerenderGridBod.call(_this$rerenderGridBod2);
        this.resetRow(visibleRowIndex);
      }
      return didModify; // Mostly just here for typing
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var didModify = _get(_getPrototypeOf(RowHeightVirtualizationUtils.prototype), "pruneHiddenColumnHeights", this).call(this, visibleColumns);
      if (didModify) {
        this.resetRow(0);
      }
      return didModify; // Mostly just here for typing
    }
  }, {
    key: "resetRow",
    value: function resetRow(visibleRowIndex) {
      var _this3 = this;
      // save the first row index of batch, reassigning it only
      // if this visible row index less than lastUpdatedRow
      this.lastUpdatedRow = Math.min(this.lastUpdatedRow, visibleRowIndex);
      clearTimeout(this.timerId);
      this.timerId = window.setTimeout(function () {
        return _this3.resetGrid();
      }, 0);
    }
  }, {
    key: "resetGrid",
    value: function resetGrid() {
      var _this$gridRef$current;
      (_this$gridRef$current = this.gridRef.current) === null || _this$gridRef$current === void 0 || _this$gridRef$current.resetAfterRowIndex(this.lastUpdatedRow);
      this.lastUpdatedRow = Infinity;
    }
  }, {
    key: "compensateForLayoutShift",
    value: function compensateForLayoutShift(rowIndex, verticalLayoutShift, anchorRow) {
      var grid = this.gridRef.current;
      var outerGridElement = this.outerGridElementRef.current;
      var renderedItems = this.gridItemsRenderedRef.current;
      if (grid == null || outerGridElement == null || renderedItems == null || anchorRow == null || !Number.isFinite(verticalLayoutShift)) {
        return;
      }

      // skip if the start row is the anchor row but it hasn't shifted
      if (anchorRow === 'start' && renderedItems.visibleRowStartIndex !== rowIndex) {
        return;
      }

      // skip if the center row is the anchor row but it hasn't shifted
      if (anchorRow === 'center' && Math.floor((renderedItems.visibleRowStopIndex - renderedItems.visibleRowStartIndex) / 2) !== rowIndex) {
        return;
      }
      grid.scrollTo({
        scrollTop: outerGridElement.scrollTop + verticalLayoutShift
      });
    }
  }]);
}(RowHeightUtils);

/**
 * Hook for instantiating RowHeightUtils, setting internal class vars,
 * and setting up various row-height-related side effects
 */
export var useRowHeightUtils = function useRowHeightUtils(_ref3) {
  var virtualization = _ref3.virtualization,
    rowHeightsOptions = _ref3.rowHeightsOptions,
    columns = _ref3.columns;
  var forceRenderRef = useLatest(useForceRender());
  var _useState = useState(function () {
      if (virtualization) {
        var _gridRef = virtualization.gridRef,
          _outerGridElementRef = virtualization.outerGridElementRef,
          _gridItemsRenderedRef = virtualization.gridItemsRenderedRef;
        return new RowHeightVirtualizationUtils(_gridRef, _outerGridElementRef, _gridItemsRenderedRef, forceRenderRef);
      } else {
        return new RowHeightUtils();
      }
    }),
    _useState2 = _slicedToArray(_useState, 1),
    rowHeightUtils = _useState2[0];

  // Forces a rerender whenever the row heights change, as this can cause the
  // grid to change height/have scrollbars. Without this, grid rerendering is stale
  useEffect(function () {
    if (forceRenderRef.current == null) {
      return;
    }
    requestAnimationFrame(forceRenderRef.current);
  }, [// Effects that should cause rerendering
  rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight, rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.rowHeights,
  // Dependencies
  rowHeightUtils, forceRenderRef]);

  // Update row heights map to remove hidden columns whenever orderedVisibleColumns change
  useEffect(function () {
    rowHeightUtils.pruneHiddenColumnHeights(columns);
  }, [rowHeightUtils, columns]);
  return rowHeightUtils;
};
export var useDefaultRowHeight = function useDefaultRowHeight(_ref4) {
  var rowHeightsOptions = _ref4.rowHeightsOptions,
    rowHeightUtils = _ref4.rowHeightUtils;
  var _useContext = useContext(DataGridSortedContext),
    getCorrectRowIndex = _useContext.getCorrectRowIndex;

  // `minRowHeight` is primarily used by undefined & lineCount heights
  // and ignored by auto & static heights (unless the static height is < the min)
  var _useState3 = useState(DEFAULT_ROW_HEIGHT),
    _useState4 = _slicedToArray(_useState3, 2),
    minRowHeight = _useState4[0],
    setRowHeight = _useState4[1];

  // Default/fallback height for all rows
  var defaultRowHeight = useMemo(function () {
    return rowHeightsOptions !== null && rowHeightsOptions !== void 0 && rowHeightsOptions.defaultHeight ? rowHeightUtils.getCalculatedHeight(rowHeightsOptions.defaultHeight, minRowHeight) : minRowHeight;
  }, [rowHeightsOptions, minRowHeight, rowHeightUtils]);

  // Used by react-window's Grid component to determine actual row heights
  var getRowHeight = useCallback(function (rowIndex) {
    var correctRowIndex = getCorrectRowIndex(rowIndex);
    var rowHeight;

    // Account for row-specific height overrides
    var rowHeightOption = rowHeightUtils.getRowHeightOption(correctRowIndex, rowHeightsOptions);
    if (rowHeightOption) {
      rowHeight = rowHeightUtils.getCalculatedHeight(rowHeightOption, minRowHeight, correctRowIndex, rowHeightsOptions);
    }

    // Use the row-specific height if it exists, if not, fall back to the default
    return rowHeight || defaultRowHeight;
  }, [minRowHeight, rowHeightsOptions, getCorrectRowIndex, rowHeightUtils, defaultRowHeight]);
  return {
    defaultRowHeight: defaultRowHeight,
    setRowHeight: setRowHeight,
    getRowHeight: getRowHeight
  };
};